<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 ">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
            <?php echo e(isset($role) ? __('role_permission.edit_role_permission') : __('role_permission.create_role_and_permission')); ?>

        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="<?php echo e(isset($role) ? route('roles.update', $role->id) : route('roles.store')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($role)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <label class="block">
                    <span><?php echo e(__('role_permission.role')); ?></span>
                    <span class="relative mt-1.5 flex">
                        <input name="name" value="<?php echo e(old('name', $role->name ?? '')); ?>"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="<?php echo e(__('role_permission.enter_role')); ?>" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-building text-base"></i>
                        </span>
                    </span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </label>

              

                
                <label class="block">
                    <span><?php echo e(__('global.status')); ?></span>
                    <span class="relative mt-1.5 flex">
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="status" type="radio" value="active" <?php echo e(old('status', $role->status ?? 'active') == 'active' ? 'checked' : ''); ?> />
                            <p><?php echo e(__('global.active')); ?></p>
                        </label>
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="status" type="radio" value="inactive" <?php echo e(old('status', $role->status ?? '') == 'inactive' ? 'checked' : ''); ?> />
                            <p><?php echo e(__('global.inactive')); ?></p>
                        </label>
                    </span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </label>

            </div>



            <div class="grid border-t mt-4 grid-cols-1 gap-4 sm:grid-cols-1">
                   <label class="block">
                        <div class="flex items-center justify-between mb-2 mt-4">
                            <span><?php echo e(__('role_permission.choose_permission')); ?><span class="text-red-500 text-xs">*</span></span>
                        </div>
                        <div class="">
                      
                                <?php
                                    $groupedPermissions = $permissions->groupBy(function ($permission) {
                                        return explode('.', $permission->name)[0];
                                    });
                                ?>

                                <div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $groupedPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module => $perms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-6 border p-3 rounded-lg dark:border-navy-500">
                                            <div class="flex items-center justify-between mb-2 border-b">
                                                <h3 class="text-lg font-semibold"><?php echo e(ucfirst($module)); ?></h3>
                                                <label class="inline-flex items-center space-x-2 cursor-pointer">
                                                    <input
                                                        type="checkbox"
                                                        class="module-select-all form-checkbox size-5 border-slate-400 dark:border-navy-400"
                                                        data-module="<?php echo e($module); ?>"
                                                    />
                                                    <span class="text-sm">Select All</span>
                                                </label>
                                            </div>

                                            <div class="grid grid-cols-4 sm:grid-cols-4 gap-4">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $perms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <label class="inline-flex items-center space-x-2">
                                                        <input
                                                            type="checkbox"
                                                            name="permissions[]"
                                                            value="<?php echo e($permission->id); ?>"
                                                            class="permission-checkbox"
                                                            data-module="<?php echo e($module); ?>"
                                                            <?php echo e(in_array($permission->id, old('permissions', $rolePermissions ?? [])) ? 'checked' : ''); ?>

                                                        />
                                                        <span><?php echo e(ucfirst(explode('.', $permission->name)[1])); ?></span>
                                                    </label>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['permissions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </label>
            </div>


            
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="<?php echo e(route('roles.index')); ?>"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90">
                    <?php echo e(__('global.cancel')); ?>

                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90 ml-2">
                    <?php echo e(isset($role) ? __('global.update') : __('global.save')); ?>

                </button>
            </div>
        </form>
    </div>
</div>


<script>
   document.addEventListener("DOMContentLoaded", function () {
    // Get all "Select All" module checkboxes
    const moduleSelectAllCheckboxes = document.querySelectorAll(".module-select-all");

    moduleSelectAllCheckboxes.forEach(moduleCheckbox => {
        const module = moduleCheckbox.dataset.module;

        // When the module "Select All" checkbox changes
        moduleCheckbox.addEventListener("change", () => {
            const permissionsInModule = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]`);
            permissionsInModule.forEach(cb => cb.checked = moduleCheckbox.checked);
        });

        // Sync "Select All" checkbox if all individual permissions are selected/deselected
        const permissionsInModule = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]`);
        permissionsInModule.forEach(cb => {
            cb.addEventListener("change", () => {
                const allChecked = [...permissionsInModule].every(c => c.checked);
                moduleCheckbox.checked = allChecked;
            });
        });

        // Initial sync on page load
        const allCheckedInit = [...document.querySelectorAll(`.permission-checkbox[data-module="${module}"]`)].every(c => c.checked);
        moduleCheckbox.checked = allCheckedInit;
    });
});

</script>
<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/configuration/roles/_form.blade.php ENDPATH**/ ?>