<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">

    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/'. $currentBranch->logo)); ?>" />

    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('storage/'. $currentBranch->logo)); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('storage/'. $currentBranch->logo)); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('storage/'. $currentBranch->logo)); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('storage/'. $currentBranch->logo)); ?>">

    <!-- Optional: Safari pinned tab icon -->
    <link rel="mask-icon" href="<?php echo e(asset('storage/'. $currentBranch->logo)); ?>" color="#5bbad5">

    <!-- iOS status bar color -->
    <meta name="apple-mobile-web-app-status-bar-style" content="default">


    <meta name="flash-success" content="<?php echo e(session('success')); ?>">
    <meta name="flash-error" content="<?php echo e(session('error')); ?>">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport"
        content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e(config('app.name')); ?> <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($title)): ?>
            - <?php echo e($title); ?> 
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </title>

    <!-- CSS & JS Assets -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Battambang:wght@400;700&family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />
    <script>
        /**
         * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
         */
        localStorage.getItem("_x_darkMode_on") === "true" &&
            document.documentElement.classList.add("dark");
    </script>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($head)): ?>
        <?php echo e($head); ?>

    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

</head>

<body x-data x-bind="$store.global.documentBody"
    class="<?php if(isset($isSidebarOpen)): ?> <?php echo e($isSidebarOpen === 'true' ? 'is-sidebar-open' : ''); ?> <?php endif; ?> <?php if(isset($isHeaderBlur)): ?> <?php echo e($isHeaderBlur === 'true' ? 'is-header-blur' : ''); ?> <?php endif; ?> <?php if(isset($hasMinSidebar)): ?> <?php echo e($hasMinSidebar === 'true' ? 'has-min-sidebar' : ''); ?> <?php endif; ?>  <?php if(isset($headerSticky)): ?> <?php echo e($headerSticky === 'false' ? 'is-header-not-sticky' : ''); ?> <?php endif; ?>">

    <!-- App preloader-->
    <?php if (isset($component)) { $__componentOriginalcfeb5813eb5e125a185268bd877f5256 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcfeb5813eb5e125a185268bd877f5256 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-preloader','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-preloader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcfeb5813eb5e125a185268bd877f5256)): ?>
<?php $attributes = $__attributesOriginalcfeb5813eb5e125a185268bd877f5256; ?>
<?php unset($__attributesOriginalcfeb5813eb5e125a185268bd877f5256); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcfeb5813eb5e125a185268bd877f5256)): ?>
<?php $component = $__componentOriginalcfeb5813eb5e125a185268bd877f5256; ?>
<?php unset($__componentOriginalcfeb5813eb5e125a185268bd877f5256); ?>
<?php endif; ?>

    <!-- Page Wrapper -->
    <div id="root" class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900" x-cloak>
        <!-- Sidebar -->
        <div class="sidebar print:hidden">
            <!-- Main Sidebar -->
            <?php if (isset($component)) { $__componentOriginal3756da08a00c4ba798da68a86d4bf471 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3756da08a00c4ba798da68a86d4bf471 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-partials.sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-partials.sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3756da08a00c4ba798da68a86d4bf471)): ?>
<?php $attributes = $__attributesOriginal3756da08a00c4ba798da68a86d4bf471; ?>
<?php unset($__attributesOriginal3756da08a00c4ba798da68a86d4bf471); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3756da08a00c4ba798da68a86d4bf471)): ?>
<?php $component = $__componentOriginal3756da08a00c4ba798da68a86d4bf471; ?>
<?php unset($__componentOriginal3756da08a00c4ba798da68a86d4bf471); ?>
<?php endif; ?>

            <!-- Sidebar Panel -->
            <?php if (isset($component)) { $__componentOriginalf4cb6f27fe022c84a2121083263d9ef6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf4cb6f27fe022c84a2121083263d9ef6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-partials.sidebar-panel','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-partials.sidebar-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf4cb6f27fe022c84a2121083263d9ef6)): ?>
<?php $attributes = $__attributesOriginalf4cb6f27fe022c84a2121083263d9ef6; ?>
<?php unset($__attributesOriginalf4cb6f27fe022c84a2121083263d9ef6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf4cb6f27fe022c84a2121083263d9ef6)): ?>
<?php $component = $__componentOriginalf4cb6f27fe022c84a2121083263d9ef6; ?>
<?php unset($__componentOriginalf4cb6f27fe022c84a2121083263d9ef6); ?>
<?php endif; ?>
        </div>

        <!-- App Header -->
        <?php if (isset($component)) { $__componentOriginal298d1db4bb78c88ddfe2932420c8fc8d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal298d1db4bb78c88ddfe2932420c8fc8d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-partials.header','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-partials.header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal298d1db4bb78c88ddfe2932420c8fc8d)): ?>
<?php $attributes = $__attributesOriginal298d1db4bb78c88ddfe2932420c8fc8d; ?>
<?php unset($__attributesOriginal298d1db4bb78c88ddfe2932420c8fc8d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal298d1db4bb78c88ddfe2932420c8fc8d)): ?>
<?php $component = $__componentOriginal298d1db4bb78c88ddfe2932420c8fc8d; ?>
<?php unset($__componentOriginal298d1db4bb78c88ddfe2932420c8fc8d); ?>
<?php endif; ?>
<?php /*
        <!-- Mobile Searchbar -->
        @component('Illuminate\View\AnonymousComponent', 'app-partials.mobile-searchbar', ['view' => 'components.app-partials.mobile-searchbar','data' => []])
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>
 @endComponentClass

        <!-- Right Sidebar -->
        @component('Illuminate\View\AnonymousComponent', 'app-partials.right-sidebar', ['view' => 'components.app-partials.right-sidebar','data' => []])
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>
 @endComponentClass
*/ ?>
        <?php echo e($slot); ?>


    </div>

    <!--
  This is a place for Alpine.js Teleport feature
  @see https://alpinejs.dev/directives/teleport
-->
    <div id="x-teleport-target"></div>
 


    <script>
        window.addEventListener("DOMContentLoaded", () => Alpine.start());   
    </script>
   
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($script)): ?>
        <?php echo e($script); ?>

    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('success') || session()->has('error')): ?>
        <div 
        x-data 
        x-init="
                $notification({
                text: '<?php echo e(session('success') ?? session('error')); ?>',
                variant: '<?php echo e(session('success') ? 'success' : 'error'); ?>',
                position: 'center-top',
                duration: 5000,
                })
            "
            ></div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/dataTables.bootstrap5.min.js"></script>
    <link href="https://cdn.datatables.net/1.12.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/tom-select/dist/js/tom-select.complete.min.js"></script>

</body>

</html>
<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/components/app-layout.blade.php ENDPATH**/ ?>