
<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
           <?php echo e(__('booking.order_entry')); ?>

        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="" enctype="multipart/form-data" class="space-y-4">
            <?php echo csrf_field(); ?>

          <div class="grid grid-cols-1 gap-3 sm:grid-cols-4">

          <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100"><?php echo e(__('booking.customers')); ?> <span class="text-red-300 text-xs mt-1">*</span></span>
               <select     name="customer_id"
                x-model="$store.deliveryForm.selectedCustomerId"
                @change="$dispatch('customer-updated')"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: '<?php echo e(__('booking.search_select_customer')); ?>',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value=""><?php echo e(__('booking.select_customer')); ?></option>
                 <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $customer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customerOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <option value="<?php echo e($customerOption->id); ?>"
                            <?php echo e(old('customer_id') == $customerOption->id ? 'selected' : ''); ?>>
                            <?php echo e($customerOption->customer_name); ?> <?php echo e($customerOption->phone); ?> (<?php echo e($customerOption->type_of_customer); ?>)
                        </option>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </select>
              
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['customer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </label>
        </div>


           
        <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100"><?php echo e(__('booking.from_warehouse')); ?> <span class="text-red-300 text-xs mt-1">*</span></span>
                <select name="from_warehouse"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: '<?php echo e(__('booking.search_warehouse')); ?>',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value=""><?php echo e(__('booking.select_from_warehouse')); ?></option>
                 <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $warehouse; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                            <option value="<?php echo e($id); ?>" <?php echo e(old('from_warehouse') == $id ? 'selected' : ''); ?>>
                                <?php echo e($name); ?>

                            </option>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </select>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['from_warehouse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </label>
        </div>



        <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100"><?php echo e(__('booking.to_warehouse')); ?> <span class="text-red-300 text-xs mt-1">*</span></span>
                <select name="to_warehouse"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: '<?php echo e(__('booking.search_to_warehouse')); ?>',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value=""><?php echo e(__('booking.select_to_warehouse')); ?></option>
                 <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $warehouse; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                            <option value="<?php echo e($id); ?>" <?php echo e(old('to_warehouse') == $id ? 'selected' : ''); ?>>
                                <?php echo e($name); ?>

                            </option>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </select>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['to_warehouse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </label>
        </div>

          
       
        </div>

            <!-- Batch Data Inquiry-->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
            <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                <ul>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <li>- <?php echo e($error); ?></li>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </ul>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


        <div x-data="bankTable()" x-init="init()" @customer-updated.window="watchCustomer()" class="mt-6">
            <h3 class="text-lg font-medium mb-2"><?php echo e(__('booking.create_order')); ?></h3>
            <div class="w-full">
                <table class="is-hoverable w-full text-left data-table">
                    <thead class="w-full bg-slate-100 dark:bg-navy-600">
                        <tr>
                            <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2"><?php echo e(__('booking.import_by')); ?></th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2"><?php echo e(__('booking.tracking')); ?></th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2"><?php echo e(__('booking.actual_weight')); ?></th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2"><?php echo e(__('booking.dimensions_cm')); ?> (CM<sup>3</sup>)</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2"><?php echo e(__('booking.chargeable_cbm')); ?></th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2"><?php echo e(__('booking.pcs')); ?></th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2"><?php echo e(__('booking.total_fee')); ?></th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2"><?php echo e(__('booking.upload_photo')); ?></th>
                            <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                                <button type="button" @click="addRow()"
                                    class="btn rounded-full bg-green-500 text-white hover:bg-green-600">
                                    <?php echo e(__('booking.add_record')); ?>

                                </button>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <template x-for="(row, index) in rows" :key="index">
                        <tr>
                            <!-- Zone Select -->
                            <td class="p-2">
                                <div x-data>
                                    <select :name="`items[${index}][shipping_method]`" x-model="row.shipping_method"
                                            x-init="$nextTick(() => new TomSelect($el, {
                                                create: false,
                                                sortField: {
                                                field: 'text',
                                                direction: 'asc'
                                            },
                                            placeholder: '<?php echo e(__('booking.search')); ?>',
                                                }))"
                                            class="w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                                            >
                                            <option value=""><?php echo e(__('booking.select_shipping_method')); ?></option>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $shippingMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                                                <option value="<?php echo e($method->value); ?>">
                                                    <?php echo e($method->label()); ?>

                                                </option>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>

                                        </select>
                                </div>
                                
                            </td>

                            <!-- Tracking -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][tracking_number]`" x-model="row.tracking_number"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="<?php echo e(__('booking.tracking')); ?>">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>

                            <!-- KG -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][kg]`" x-model="row.kg"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="26.90">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>

                             <!-- cm -->
                            <td class="p-2">
                                <span class="relative flex">
                                   <input type="text" :name="`items[${index}][cm]`" x-model="row.cm"
                                    @input="calculateCBM(index)"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="74x63x30">

                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>


                             <!-- CBM -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][cbm]`" x-model="row.cbm"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="0.14">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>

                            <!-- PCS -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][pcs]`" x-model="row.pcs"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="2">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>


                            <!-- Fee -->
                            <td class="p-2">
                                <span class="relative flex">
                                <input type="text" :name="`items[${index}][amount_usd]`" x-model="row.amount_usd"
                                    class="form-input peer  w-[150px] rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="23.80">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fas fa-money-bill"></i>
                                    </span>
                                </span>
                            </td>

                            <td class="p-2">
                                <div class="flex items-center gap-2">
                                    <!-- File input -->
                                    <input
                                        type="file"
                                        accept="image/*"
                                        :name="`items[${index}][photo]`"
                                        @change="previewImage($event, index)"
                                        class="block w-full text-xs text-slate-500
                                            file:mr-2 file:rounded-full file:border-0
                                            file:bg-primary file:px-3 file:py-1
                                            file:text-white hover:file:bg-primary-focus"
                                    >

                                    <!-- Image preview -->
                                    <template x-if="row.preview">
                                        <img
                                            :src="row.preview"
                                            class="h-10 w-10 rounded border object-cover"
                                            alt="<?php echo e(__('booking.preview')); ?>"
                                        >
                                    </template>
                                </div>
                            </td>


                            <!-- Remove Button -->
                            <td class="p-2 text-center">
                                <div @click="removeRow(index)" class="badge cursor-pointer p-2 space-x-2 bg-red-100 text-red-800 dark:bg-red-500 dark:text-white">
                                    <i class="fas fa-trash"></i>
                                    <span><?php echo e(__('booking.remove')); ?></span>
                                </div>
                            </td>
                        </tr>
                    </template>

                    </tbody>
                </table>
            </div>
           
        </div>
            <!-- Form Buttons -->
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="<?php echo e(route('customer.index')); ?>"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                    <?php echo e(__('global.cancel')); ?>

                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2">
                   <?php echo e(__('global.save')); ?>

                </button>
            </div>
        </form>
    </div>
</div>
<script>
    window.oldItems = <?php echo json_encode(old('items', []), 512) ?>;

 
function bankTable() {
    return {
        rows: window.oldItems.length
            ? window.oldItems.map(item => ({
                ...item,
                preview: item.preview ?? null,
            }))
            : [
                {
                    shipping_method: '',
                    tracking_number: '',
                    kg: '',
                    cm: '',
                    cbm: '',
                    pcs: '',
                    amount_usd: '',
                    preview: null,
                }
            ],

        init() {},

        addRow() {
            this.rows.push({
                shipping_method: '',
                tracking_number: '',
                kg: '',
                cm: '',
                cbm: '',
                pcs: '',
                amount_usd: '',
                preview: null,
            });
        },

        removeRow(index) {
            this.rows.splice(index, 1);
        },

        previewImage(event, index) {
            const file = event.target.files[0];
            if (!file) return;

            if (!file.type.startsWith('image/')) {
                alert(<?php echo json_encode(__('booking.upload_image_only'), 15, 512) ?>);
                event.target.value = '';
                return;
            }

            const reader = new FileReader();
            reader.onload = e => {
                this.rows[index].preview = e.target.result;
            };
            reader.readAsDataURL(file);
        },

        // NEW: calculate CBM when dimensions change
        calculateCBM(index) {
            const dims = this.rows[index].cm.split('x').map(Number);
            if (dims.length === 3 && dims.every(d => !isNaN(d))) {
                const [l, w, h] = dims;
                this.rows[index].cbm = (l * w * h / 1000000).toFixed(2);
            } else {
                this.rows[index].cbm = '';
            }
        }
    };
}
</script>

<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/booking/inquiry/_form.blade.php ENDPATH**/ ?>