<?php

use App\Http\Controllers\Admin\ActivityLogController;
use App\Http\Controllers\AssignDriverController;
use App\Http\Controllers\AssignZoneController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\BookingOrderController;
use App\Http\Controllers\BookingPickUpController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\CancelReasonController;
use App\Http\Controllers\ChangeDriverController;
use App\Http\Controllers\ConfigurationController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\CustomerSummaryDashboardController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DataInquiryController;
use App\Http\Controllers\DeliveryController;
use App\Http\Controllers\DeliveryScanAssignController;
use App\Http\Controllers\DriverCollectPaymentController;
use App\Http\Controllers\DriverPaymentController;
use App\Http\Controllers\DriverSummaryDashboardController;
use App\Http\Controllers\ExchangeRateController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ImportDeliveryController;
use App\Http\Controllers\InTransitController;
use App\Http\Controllers\RemoveDeliveryController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ReturnDeliveryController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\ShipmentController;
use App\Http\Controllers\ShopCollectPaymentController;
use App\Http\Controllers\ShopSummaryPaymentController;
use App\Http\Controllers\TrackingController;
use App\Http\Controllers\TransitController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\WarehouseController;
use App\Http\Controllers\ZonePriceController;
use App\Http\Controllers\ZoneTypesController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('lang/{locale}', function ($locale) {
    if (! in_array($locale, ['en', 'km', 'zh'])) {
        abort(400);
    }
    if (auth()->check()) {
        auth()->user()->update(['locale' => $locale]);
    }

    session(['locale' => $locale]);

    return redirect()->back();
})->name('lang.switch');

Route::get('logs', '\Rap2hpoutre\LaravelLogViewer\LogViewerController@index')->middleware('auth');

Route::get('/', [HomeController::class, 'index'])->name('home.index');

Route::middleware('guest')->group(function () {
    Route::get('/login', [\App\Http\Controllers\AuthController::class, 'loginView'])->name('loginView');
    Route::post('/login', [\App\Http\Controllers\AuthController::class, 'login'])->name('login');
    // Route::get('/register', [\App\Http\Controllers\AuthController::class, 'registerView'])->name('registerView');
    // Route::post('/register', [\App\Http\Controllers\AuthController::class, 'register'])->name('register');
});

Route::get('/api/search/tracking', [TrackingController::class, 'tracking'])->name('tracking.search');

Route::middleware('auth')->group(function () {
    Route::resource('dashboards', DashboardController::class);
    Route::resource('driver-summary-dashboard', DriverSummaryDashboardController::class);
    Route::resource('customer-summary-dashboard', CustomerSummaryDashboardController::class);

    Route::group(['prefix' => 'order'], function () {
        Route::resource('booking', BookingController::class);
        Route::get('/print-invoice/{id}', [BookingController::class, 'printInvoice'])
            ->name('printInvoicePickup');

        Route::get('/booking-ajax', [BookingController::class, 'bookingAjax'])->name('bookingAjax');
        Route::post('/booking/status', [BookingController::class, 'processUpdateStatus'])->name('booking.status');
        Route::resource('booking-order', BookingOrderController::class);
        Route::get('/print-label/{id}', [BookingOrderController::class, 'printLable'])
            ->name('printLable');
        // Transit
        Route::resource('transit', TransitController::class);
        Route::get('/transit-ajax', [TransitController::class, 'transitAjax'])->name('transitAjax');
        // In Transit
        Route::resource('in-transit', InTransitController::class);
        Route::get('/in-transit-ajax', [InTransitController::class, 'inTransitAjax'])->name('inTransitAjax');
        Route::get('/in-transit-print-invoice/{invoice}', [InTransitController::class, 'printInvoiceInTransit'])
            ->name('printInvoiceInTransit');
        Route::post('/intransit/status', [InTransitController::class, 'updateStatusArrived'])->name('inTransit.status');
        // shipment
        Route::resource('shipment', ShipmentController::class);
        Route::get('/shipment-ajax', [ShipmentController::class, 'shipmentAjax'])->name('shipmentAjax');

    });

    Route::group(['prefix' => 'dlv'], function () {
        Route::resource('customer', CustomerController::class);
        Route::post('/customers/{customer}/register-login', [CustomerController::class, 'registerLogin'])
            ->name('customer.register-login');
        Route::post('/admin/login-as-customer/{customer}', [CustomerController::class, 'loginAsCustomer'])
        ->name('admin.login-as-customer')
        ->middleware('auth', 'role:admin');
        //book pickup
        Route::resource('book-pickup', BookingPickUpController::class);
        Route::post('/assign-pickup/status', [BookingPickUpController::class, 'processAssignPickup'])->name('assignPickup.status');


        Route::resource('data-inquiry', DataInquiryController::class);
        Route::get('/data-inquiry/print-invoice/{id}', [DataInquiryController::class, 'inquiryPrintInvoice'])
            ->name('inquiry.invoice.print');
        Route::get('/data-inquiry/print-invoice-batch/{ids}', [DataInquiryController::class, 'inquiryPrintBatchInvoice'])->name('inquiry.invoice.batch');

        Route::resource('delivery', DeliveryController::class);
        Route::get('/delivery-ajax', [DeliveryController::class, 'deliveryAjax'])->name('deliveryAjax');
        Route::get('/print-invoice/{id}', [DeliveryController::class, 'printInvoice'])->name('printInvoice');
        Route::get('/delivery-ajax-dashboard', [DeliveryController::class, 'deliveryAjaxDashboard'])->name('deliveryAjaxDashboard');

        
        // assign driver
        Route::get('/assign-driver', [AssignDriverController::class, 'assignDriver'])->name('assign-driver.index');
        Route::get('/assign-driver/ajax', [AssignDriverController::class, 'index'])->name('assign-driver.ajax');
        Route::post('/assign-driver/store', [AssignDriverController::class, 'store'])->name('assign-driver.store');
        // Import delivery
        Route::get('/import-delivery', [ImportDeliveryController::class, 'index'])->name('importDelivery.index');
        Route::post('/delivery/import', [ImportDeliveryController::class, 'import'])
            ->name('delivery.import');

        // Scan assign
        Route::get('/scan-assign', [DeliveryScanAssignController::class, 'scanDriver'])->name('scan-assign.index');
        Route::get('/scan-assign/ajax', [DeliveryScanAssignController::class, 'index'])->name('scan-assign.ajax');
        Route::post('/scan-assign/store', [DeliveryScanAssignController::class, 'store'])->name('scan-assign.store');
        Route::get('/scan-delivery', [DeliveryScanAssignController::class, 'scan'])->name('scan.delivery');

        // change driver
        Route::get('/change-driver', [ChangeDriverController::class, 'changeDriver'])->name('change-driver.index');
        Route::get('/change-driver/ajax', [ChangeDriverController::class, 'index'])->name('change-driver.ajax');
        Route::post('/change-driver/store', [ChangeDriverController::class, 'store'])->name('change-driver.store');
        // remove delivery
        Route::get('/remove-delivery', [RemoveDeliveryController::class, 'removeDelivery'])->name('remove-delivery.index');
        Route::get('/remove-delivery/ajax', [RemoveDeliveryController::class, 'index'])->name('remove-delivery.ajax');
        Route::post('/remove-delivery/store', [RemoveDeliveryController::class, 'store'])->name('remove-delivery.store');

        // return delivery
        Route::get('/return-delivery', [ReturnDeliveryController::class, 'returnDelivery'])->name('return-delivery.index');
        Route::get('/return-delivery/ajax', [ReturnDeliveryController::class, 'index'])->name('return-delivery.ajax');
        Route::post('/return-delivery/store', [ReturnDeliveryController::class, 'store'])->name('return-delivery.store');

        Route::post('/delivery/payment', [DeliveryController::class, 'processPayment'])->name('delivery.payment');
        Route::post('/delivery/cancel-reason', [DeliveryController::class, 'processCancelReason'])->name('delivery.cancel-reason');
        Route::get('/get-express-fee', [DeliveryController::class, 'getExpressFee'])->name('getExpressFee');

    });

    Route::group(['prefix' => 'collect'], function () {
        // driver
        Route::resource('driver-payment', DriverPaymentController::class);
        Route::resource('driver-collect-payment', DriverCollectPaymentController::class);
        Route::post('/driver-collect-payment/delivery/ajust', [DriverCollectPaymentController::class, 'adjustDeliveryPayment'])->name('adjustDeliveryPayment');

        // shop
        Route::resource('shop-summary-payment', ShopSummaryPaymentController::class);
        Route::resource('shop-collect-payment', ShopCollectPaymentController::class);
        Route::get('/all-shop', [ShopCollectPaymentController::class, 'all'])->name('all-shop-collect-payment.index');
        Route::get('/generated-invoice/{customer_id}', [ShopCollectPaymentController::class, 'generatedInvoice'])->name('generatedInvoice');

        //  Route::get('/shop-collect-payment-show', [ShopCollectPaymentController::class, 'shopCollectPayment'])->name('shopCollectPayment');

        Route::get('/shop-collect-payment/download/{invoice}', [ShopCollectPaymentController::class, 'download'])->name('shopCollectPayment.download');
        Route::get('/shop-collect-payment/download/{invoice}/download-view', [ShopCollectPaymentController::class, 'invoice'])
            ->name('shopCollectPayment.view.download')
            ->withoutMiddleware(['auth']);

        Route::POST('/transfer-to-shop-completed', [ShopSummaryPaymentController::class, 'transferToShopCompleted'])->name('transferToShopCompleted');
        Route::get('/eod', [ShopSummaryPaymentController::class, 'eod'])->name('summaryIncomeFromDelivery.index');

    });

    Route::group(['prefix' => 'configuration'], function () {
        Route::get('/', [ConfigurationController::class, 'index'])->name('configuration.index');
        Route::resource('roles', RoleController::class);
        Route::resource('global-exchange-rate', ExchangeRateController::class);
        Route::resource('users', UserController::class);
        Route::resource('branch', BranchController::class);
        Route::resource('warehouse', WarehouseController::class);
        Route::resource('zone-types', ZoneTypesController::class);
        Route::resource('zone-price', ZonePriceController::class);
        Route::resource('assign-zones', AssignZoneController::class);
        Route::put('assign-zones/{driver_id}', [AssignZoneController::class, 'update'])->name('assignZones.update');

        Route::resource('cancel-reason', CancelReasonController::class);

        Route::post('/switch-branch', [BranchController::class, 'switch'])->name('switch-branch');

    });

    Route::group(['prefix' => 'reports'], function () {
        Route::get('/', [ReportController::class, 'index'])->name('reports.index');
        Route::get('/driver-earning', [ReportController::class, 'driverEarning'])->name('driverEarning.index');
        Route::get('/pickup-commission', [ReportController::class, 'pickUpCommission'])->name('pickUpCommission.index');
        Route::get('/income-shop', [ReportController::class, 'incomeShop'])->name('incomeShop.index');

    });

    Route::group(['prefix' => 'admin'], function () {
        Route::get('/setting', [SettingController::class, 'index'])->name('setting.index');
        Route::get('/activity-logs', [ActivityLogController::class, 'index'])->name('admin.activity-logs');
    });

    Route::post('/logout', [\App\Http\Controllers\AuthController::class, 'logout'])->name('logout');

});
