<?php

use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\DeliveryController;
use App\Http\Controllers\Api\DeliveryStatusController;
use App\Http\Controllers\Api\DriverController;
use App\Http\Controllers\Api\DriverSummaryController;
use App\Http\Controllers\Api\DriverSummaryPaymentController;
use App\Http\Controllers\Api\SearchController;
use App\Http\Controllers\Api\UserDeleteAccountController;
use App\Http\Middleware\SetApiLocale;
use Illuminate\Support\Facades\Route;

Route::post('/login', [LoginController::class, 'login']);

Route::middleware(['auth:sanctum',SetApiLocale::class])->group(function () {
    //Driver Summary
    Route::get('/driver-summary-dashboard', [DriverSummaryController::class, 'dashboard']);

    //Delivery Listing 
    Route::get('/delivery-listing', [DeliveryController::class, 'deliveryListing']);
    Route::get('/delivery/{id}/detail', [DeliveryController::class, 'details']);

    Route::post('/delivery-completed-payment', [DeliveryController::class, 'processCompletedPayment']);
    Route::post('/delivery-cancel-reason', [DeliveryController::class, 'processCancelReason']);
    //listing status
    Route::get('/delivery-status', [DeliveryStatusController::class, 'index']);
    Route::get('/delivery-payment-to', [DeliveryStatusController::class, 'paymentTo']);
    Route::get('/delivery-payment-payment-method', [DeliveryStatusController::class, 'paymentMethod']);
    Route::get('/cancel-reason', [DeliveryStatusController::class, 'cancelReason']);

    // driver
    Route::get('/driver-listing', [DriverController::class, 'driverListing']);
    Route::get('/scan', [DriverController::class, 'scan']);
    Route::get('/scan-listing', [DriverController::class, 'scanListing']);
    Route::get('/assign-package', [DriverController::class, 'assignPackage']);

    //deactive user
    Route::post('users/deactivate', [UserDeleteAccountController::class, 'deactivateSelf'])->name('api.user.deactivate');

    //search 
    Route::get('search/delivery', [SearchController::class, 'search']);

    //Driver Summary payment
    Route::get('/driver-summary-payment', [DriverSummaryPaymentController::class, 'summaryInvoice']);
    Route::get('/driver-summary-payment/{invoice}', [DriverSummaryPaymentController::class, 'invoiceDetail']);


});
