<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <title>{{ $customer->customer_name }} Invoice</title>
    <style>
   
        html, body, table, tr, td, th, p, span, div {
            font-family: 'battambang', DejaVu Sans, sans-serif !important;
            font-weight: normal;
        }
        strong, b {
            font-family: 'battambang', DejaVu Sans, sans-serif !important;
            font-weight: bold;
        }
     

        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        .section {
            margin-bottom: 20px;
            text-align: center;
        }

        .summary-box {
            margin-top: 10px;
            margin-bottom: 20px;
            border:1px solid #ccc;
            padding: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
        }

        table, th, td {
            border: 1px solid #999;
        }

        th, td {
            padding: 5px;
            text-align: center;
        }

        tfoot td {
            font-weight: bold;
        }

        .text-right {
            text-align: right;
        }

        .bold {
            font-weight: bold;
        }
            .invoice-info {
                text-align: left;
                vertical-align: top;
                border: none !important;
                font-size: 12px;
            }

            .qr-box {
                text-align: right;
                vertical-align: top;
                border: none !important;
            }

            .qr-item {
                display: inline-block;
                margin-left: 15px;
                text-align: center;
            }
.status-badge {
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 12px;
    font-weight: 600;
    display: inline-block;
}

/* Status colors */
.status-in-stock {
    background-color: #FEF3C7; /* yellow */
    color: #92400E;
}

.status-assigned {
    background-color: #DBEAFE; /* blue */
    color: #1E40AF;
}

.status-completed {
    background-color: #D1FAE5; /* green */
    color: #065F46;
}

.status-canceled {
    background-color: #FEE2E2; /* red */
    color: #991B1B;
}

.status-default {
    background-color: #F3F4F6;
    color: #374151;
}


    </style>
</head>
<body>

<div class="section">
    <h2>{{ $customer->customer_name }} Invoice</h2>
</div>

<div>
    <table>
    <tr>
        <td colspan="7" class="invoice-info">
            <strong>Invoice Number:</strong> {{ $invoiceNumber }}<br>
            <strong>Branch:</strong> {{ $branch->name }}<br>
            <strong>Date:</strong> {{ $summary->created_at->format('d M Y') }}<br>
            <strong>Exchange Rate:</strong> {{ number_format($exchangeRate, 2) }}<br>
            <strong>Total Payment:</strong><br>
            @foreach ($existingPayments as $payment)
                {{ number_format($payment['amount'], 2) }} {{ strtoupper($payment['currency']) }} <br>
            @endforeach
        </td>

        <td colspan="5" class="qr-box">
            @if(isset($customer->banks[0]))
                <div class="qr-item">
                    <img src="{{ public_path('storage/' . $customer->banks[0]->qr_code) }}" width="80"><br>
                    {{ $customer->banks[0]->bank_account_number ?? '-' }} | 
                    {{ $customer->banks[0]->bank_account_name ?? '-' }}
                </div>
            @endif

            @if(isset($customer->banks[1]))
                <div class="qr-item">
                    <img src="{{ public_path('storage/' . $customer->banks[1]->qr_code) }}" width="80"><br>
                    {{ $customer->banks[1]->bank_account_number ?? '-' }} | 
                    {{ $customer->banks[1]->bank_account_name ?? '-' }}
                </div>
            @endif
        </td>
    </tr>
</table>

</div>


<h3>Delivery Summary</h3>
<table>
    <thead>
        <tr>
            <th rowspan="2">No</th>
            <th rowspan="2">Address</th>
            <th rowspan="2">Phone</th>
            <th rowspan="2">Entry</th>
            <th rowspan="2">Completed</th>
            <th rowspan="2">Total (USD)</th>
            <th rowspan="2">Total (KHR)</th>
            <th colspan="2">COD</th>
            <th colspan="2">Shop</th>
            <th rowspan="2">Other Fee</th>
            <th rowspan="2">Delivery Fee</th>
            <th rowspan="2">Status</th>
            <th rowspan="2">Note</th>
        </tr>
        <tr>
            <th>USD</th>
            <th>KHR</th>
            <th>USD</th>
            <th>KHR</th>
        </tr>
    </thead>
    <tbody>
        @php
            $totalDriverUsd = $totalDriverKhr = $totalShopUsd = $totalShopKhr = 0;
            $totalDeliveryFee = $totalAmountUsd = $totalAmountKhr = 0;
            $totalPaidAnyExtraFee = 0;
        @endphp

        @foreach($deliveries as $index => $delivery)
            @php
                $driverUsd = $delivery->payments->where('payment_to', 'driver')->where('currency', 'usd')->sum('amount');
                $driverKhr = $delivery->payments->where('payment_to', 'driver')->where('currency', 'khr')->sum('amount');
                $companyUsd = $delivery->payments->where('payment_to', 'company')->where('currency', 'usd')->sum('amount');
                $companyKhr = $delivery->payments->where('payment_to', 'company')->where('currency', 'khr')->sum('amount');
                $shopUsd = $delivery->payments->where('payment_to', 'shop')->where('currency', 'usd')->sum('amount');
                $shopKhr = $delivery->payments->where('payment_to', 'shop')->where('currency', 'khr')->sum('amount');
                $extraFeeUsd = ($delivery->who_pay_fee === 'Driver' || $delivery->who_pay_fee === 'Company') ? ($delivery->any_extra_fee ?? 0) : 0;
                $deliveryFeeUsd = $delivery->delivery_price ?? 0;

                $totalDriverUsd += $driverUsd + $companyUsd;
                $totalDriverKhr += $driverKhr + $companyKhr;
                $totalShopUsd += $shopUsd;
                $totalShopKhr += $shopKhr;
                $totalDeliveryFee += $deliveryFeeUsd;
                $totalAmountUsd += $delivery->amount_usd ?? 0;
                $totalAmountKhr += $delivery->amount_khr ?? 0;
                $totalPaidAnyExtraFee += $extraFeeUsd;
            @endphp

            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $delivery->receiver_address ?? '-' }}</td>
                <td>{{ $delivery->receiver_phone ?? '-' }}</td>
                <td>{{ \Carbon\Carbon::parse($delivery->pickup_at)->format('d/m/Y h:i A') }}</td>
                <td>{{ $delivery->completed_at ? \Carbon\Carbon::parse($delivery->completed_at)->format('d/m/Y h:i A') : '-' }}</td>
                <td>{{ number_format($delivery->amount_usd, 2) }}</td>
                <td>{{ number_format($delivery->amount_khr, 0) }}</td>
                <td>{{ number_format($driverUsd + $companyUsd, 2) }}</td>
                <td>{{ number_format($driverKhr + $companyKhr, 0) }}</td>
                <td>{{ number_format($shopUsd, 2) }}</td>
                <td>{{ number_format($shopKhr, 0) }}</td>
                <td>{{ number_format($extraFeeUsd, 2) }}</td>
                <td>{{ number_format($deliveryFeeUsd, 2) }}</td>
                <td>{{ ucfirst($delivery->status) }}</td>
                <td>{{ $delivery->note }}</td>
            </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr>
            <td colspan="5" class="text-right">Total Collected:</td>
            <td>{{ number_format($totalAmountUsd, 2) }}</td>
            <td>{{ number_format($totalAmountKhr, 0) }}</td>
            <td>{{ number_format($totalDriverUsd, 2) }}</td>
            <td>{{ number_format($totalDriverKhr, 0) }}</td>
            <td>{{ number_format($totalShopUsd, 2) }}</td>
            <td>{{ number_format($totalShopKhr, 0) }}</td>
            <td>{{ number_format($totalPaidAnyExtraFee, 2) }}</td>
            <td>{{ number_format($totalDeliveryFee, 2) }}</td>
            <td colspan="2"></td>
        </tr>
     
    </tfoot>
</table>


<div class="section text-right bold">
    Printed on: {{ now()->format('d M Y H:i') }}
</div>

@if ($deliveryPending->isNotEmpty())
<h3>Pending</h3>

<table class="w-full border border-slate-300 text-sm">
    <thead class="bg-slate-100">
        <tr>
            <th>No</th>
            <th>Address</th>
            <th>Phone</th>
            <th>Entry</th>
            <th>Completed</th>
            <th>Total (USD)</th>
            <th>Total (KHR)</th>
            <th>Status</th>
            <th>Note</th>
        </tr>
    </thead>

    <tbody>
        @foreach ($deliveryPending as $d => $del)
            <tr class="border-t">
                <td>{{ $d + 1 }}</td>
                <td>{{ $del->receiver_address ?? '-' }}</td>
                <td>{{ $del->receiver_phone ?? '-' }}</td>
                <td>{{ \Carbon\Carbon::parse($del->pickup_at)->format('d/m/Y h:i A') }}</td>
                <td>N/A</td>
                <td>{{ number_format($del->amount_usd, 2) }}</td>
                <td>{{ number_format($del->amount_khr, 0) }}</td>

                <!-- STATUS WITH COLOR -->
                <td>
                   @php
                    $statusClass = match ($del->status) {
                        'in_stock'  => 'status-in-stock',
                        'assigned'  => 'status-assigned',
                        'completed' => 'status-completed',
                        'canceled'  => 'status-canceled',
                        default     => 'status-default',
                    };
                @endphp

                <span class="status-badge {{ $statusClass }}">
                    {{ ucfirst(str_replace('_', ' ', $del->status)) }}
                </span>

                </td>

                <td>{{ $del->cancelReason?->reason ?? $del->note ?? '-' }}</td>
            </tr>
        @endforeach
    </tbody>
</table>
@endif


</body>
</html>
