<x-app-layout title="Collect Payment With Driver" is-header-blur="false" is-sidebar-open="false" header-sticky="false" has-min-sidebar="false">
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">Collect Payment</h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">List</a>
                    <svg x-ignore xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>driver</li>
            </ul>

            <!-- Back Button -->
            <div class="ml-auto">
  
                <a href="{{ route('driver-payment.index') }}" class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">Back</a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
            <div>
                <div class="card p-2 mt-3">
                    
                @if ($errors->any())
                        <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>- {{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                                                

                    <div class="card">
                        <div class="border border-slate-200 p-2 dark:border-navy-500">
                            <form method="POST"
                                action="{{ isset($summary) ? route('driver-collect-payment.update', $summary->id) : route('driver-collect-payment.store') }}"
                                enctype="multipart/form-data" class="space-y-4"
                                id="deliveryForm"
                                x-data="{ loading: false }"
                                @submit="loading = true">
                                @csrf
                                @if (isset($summary))
                                    @method('PUT')
                                @endif
                                
                                  <div class="w-full max-w-full px-0 mx-0">
                                     <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6 w-full">
                                        <div class="card p-2">
                                            <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">

                                                <div class="mb-6 p-4 border border-slate-300 dark:border-navy-600 rounded bg-slate-50 dark:bg-navy-700">
                                                    <h2 class="text-xl text-center border-b border-slate-300 font-bold mb-4 text-slate-800 dark:text-navy-100">Driver Payment Invoice</h2>
                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div class="text-slate-700 dark:text-navy-100">
                                                            <p><span class="font-semibold">Driver Name:</span> {{ $driverName }}</p>
                                                            <p><span class="font-semibold">Exchange Rate:</span> 1 USD = {{ number_format($exchangeRate, 0) }} KHR</p>
                                                        </div>
                                                        <div class="text-right text-slate-700 dark:text-navy-100">
                                                            <p><span class="font-semibold">Invoice No:</span> {{ $invoiceNumber }}</p>
                                                            <p><span class="font-semibold">Print Date:</span> {{ now()->format('d-m-Y H:i:s') }}</p>
                                                        </div>
                                                    </div>
                                                </div>


                                            @php
                                                // Initialize Totals
                                                $totalDriverUsd = 0;
                                                $totalDriverKhr = 0;
                                                $totalShopUsd = 0;
                                                $totalShopKhr = 0;
                                                $totalCompanyUsd = 0;
                                                $totalCompanyKhr = 0;
                                                $totalDeliveryFee = 0;
                                                $totalAmountUsd = 0;
                                                $totalAmountKhr = 0;
                                                $totalAnyExtraFee = 0;
                                                
                                                // Initialize final payment amounts
                                                $totalDriverPayUsd = 0;
                                                $totalDriverPayKhr = 0;
                                            @endphp

                                            <table class="is-hoverable w-full text-left data-table border border-collapse border-slate-300 ">

                                                <thead>
                                                    <tr>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">N<sup>o</sup></th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Customer</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Address</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Phone</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Entry</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Completed</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">COD</th>
                                                        <th colspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Driver</th>
                                                        <th colspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Shop</th>
                                                        <th colspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Company</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">ExtraFee</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Fee</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Total(USD)</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Total(KHR)</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Note</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Action</th>
                                                    </tr>
                                                    <tr>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">USD</th>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">KHR</th>

                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">USD</th>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">KHR</th>

                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">USD</th>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">KHR</th>
                                                    </tr>
                                                </thead>

                                                <tbody class="gridjs-tbody">
                                                    @foreach($deliveries as $index => $delivery)
                                                        <?php
                                                            $driverUsd = $delivery->payments->where('payment_to', 'driver')->where('currency', 'usd')->sum('amount');
                                                            $driverKhr = $delivery->payments->where('payment_to', 'driver')->where('currency', 'khr')->sum('amount');

                                                            $shopUsd = $delivery->payments->where('payment_to', 'shop')->where('currency', 'usd')->sum('amount');
                                                            $shopKhr = $delivery->payments->where('payment_to', 'shop')->where('currency', 'khr')->sum('amount');

                                                            $companyUsd = $delivery->payments->where('payment_to', 'company')->where('currency', 'usd')->sum('amount');
                                                            $companyKhr = $delivery->payments->where('payment_to', 'company')->where('currency', 'khr')->sum('amount');
                                                            
                                             
                                                         
                                                         $totalAnyExtraFee = $delivery->who_pay_fee === 'Driver' ? $delivery->any_extra_fee : 0;

                                                           // Accumulate totals
                                                            $totalDriverUsd += $driverUsd;
                                                            $totalDriverKhr += $driverKhr;


                                                           // Calculate remaining balances (do not overwrite original totals)
                                                            $remainingDriverUsd = $totalDriverUsd;
                                                            $remainingDriverKhr = $totalDriverKhr;

                                                            if ($totalDriverKhr == 0) {
                                                                // Only USD is available, deduct from USD
                                                                $remainingDriverUsd = $totalDriverUsd - $totalAnyExtraFee;
                                                            } else {
                                                                if ($totalDriverUsd >= $totalAnyExtraFee) {
                                                                    // USD covers all
                                                                    $remainingDriverUsd = $totalDriverUsd - $totalAnyExtraFee;
                                                                } else {
                                                                    // Partial USD, rest from KHR
                                                                    $remainingUsd = $totalAnyExtraFee - $totalDriverUsd;
                                                                    $deductKhr = $remainingUsd * $exchangeRate;

                                                                    $remainingDriverUsd = 0;
                                                                    $remainingDriverKhr = $totalDriverKhr - $deductKhr;
                                                                }
                                                            }




                                                            $totalShopUsd += $shopUsd;
                                                            $totalShopKhr += $shopKhr;

                                                            $totalCompanyUsd += $companyUsd;
                                                            $totalCompanyKhr += $companyKhr;

                                                            $totalDeliveryFee += $delivery->delivery_price;
                                                            $totalAmountUsd += $delivery->amount_usd;
                                                            $totalAmountKhr += $delivery->amount_khr;

                                                           $usdMismatch = round($driverUsd + $shopUsd + $companyUsd, 2)
                                                                !== round($delivery->amount_usd, 2);

                                                            $khrMismatch = (int) ($driverKhr + $shopKhr + $companyKhr)
                                                                !== (int) $delivery->amount_khr;

                                                            $mismatch = ($usdMismatch || $khrMismatch) ? 'text-red-600 font-semibold' : '';


                                                        ?>
                                                        <tr>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ $index + 1 }}
                                                                 <input type="hidden" name="delivery_ids[]" value="{{ $delivery->id }}">
                                                            </td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ $delivery->customer?->customer_name ?? '-' }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ $delivery->receiver_address ?? '-' }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ $delivery->receiver_phone ?? '-' }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ \Carbon\Carbon::parse($delivery->pickup_at)->format('d-m-Y') }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">
                                                                {{ $delivery->completed_at ? \Carbon\Carbon::parse($delivery->completed_at)->format('d-m-Y') : '-' }}
                                                            </td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ $delivery->type_of_cod }}</td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($driverUsd, 2) }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($driverKhr, 0) }}</td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($shopUsd, 2) }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($shopKhr, 0) }}</td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($companyUsd, 2) }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($companyKhr, 0) }}</td>
                                                            <?php 
                                                                $extraFee = $delivery->any_extra_fee ?? 0;
                                                                $extraFeeUsd = ($delivery->who_pay_fee === 'Driver') ? $extraFee : 0;
                                                            ?>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($extraFeeUsd, 2) }}</td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($delivery->delivery_price, 2) }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($delivery->amount_usd, 2) }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ number_format($delivery->amount_khr, 0) }}</td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">{{ $delivery->note }}</td>
                                                           
                                                             <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 text-center {{ $mismatch ? 'text-red-600 font-semibold' : '' }}">
                                                            @php
                                                                $paymentData = [
                                                                    'deliveryId' => $delivery->id,
                                                                    'deliveryFee' => $delivery->delivery_price,
                                                                    'customerName' => $delivery->customer?->customer_name ?? 'N/A',
                                                                    'amountUsd' => (float) $delivery->amount_usd,
                                                                    'amountKhr' => (float) $delivery->amount_khr,
                                                                    'note' => $delivery->note,
                                                                    'payments' => $delivery->payments->map(function ($p) {
                                                                        return [
                                                                            'payment_to' => $p->payment_to,
                                                                            'amount' => (float) $p->amount,
                                                                            'currency' => $p->currency,
                                                                            'payment_method' => $p->payment_method,
                                                                        ];
                                                                    })->values()->all(),
                                                                ];
                                                            @endphp

                                                            <div
                                                                class="adjust-payment"
                                                                x-data
                                                                data-payment='@json($paymentData)'
                                                            >
                                                            <span  class="badge cursor-pointer space-x-2.5 rounded-full bg-warning/10 text-warning dark:bg-warning/15">
                                                                Adjust
                                                            </span>
                                                            </div>

                                                            </td>
                                                            
                                                        </tr>
                                                    @endforeach
                                                </tbody>

                                                <tfoot>
                                                    <tr class="font-bold dark:bg-navy-700">
                                                        <td class="text-right p-2" colspan="7">Total: </td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalDriverUsd, 2) }}</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalDriverKhr, 0) }}</td>

                                                        {{-- Shop Totals --}}
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalShopUsd, 2) }}</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalShopKhr, 0) }}</td>

                                                        {{-- Company Totals --}}
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalCompanyUsd, 2) }}</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalCompanyKhr, 0) }}</td>

                                                        {{-- Delivery Fee and Amounts --}}
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalAnyExtraFee, 2) }}</td>

                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalDeliveryFee, 2) }}</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalAmountUsd, 2) }}</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" >{{ number_format($totalAmountKhr, 0) }}</td>

                                                        {{-- Empty Delivery Status --}}
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ></td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ></td>
                                                    </tr>

                                                     <tr class="font-bold dark:bg-navy-700">
                                                        <td  class="text-right p-2" colspan="7" class="text-right">Other Extra Fee USD: </td>
                                                        <td  class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" colspan="12">{{ number_format($totalAnyExtraFee, 2) }}</td>
                                                    </tr>
                                                    <tr class="font-bold dark:bg-navy-700">
                                                        <td  class="text-right p-2" colspan="7" class="text-right">Total COD USD: </td>
                                                        <td  class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"colspan="12">
                                                            {{ number_format($totalDriverUsd, 2) }}
                                                            <input name="driver_collect_usd" value="{{ $totalDriverUsd }}" type="hidden"/>
                                                        </td>
                                                    </tr>
                                                    <tr class="font-bold dark:bg-navy-700">
                                                        <td  class="text-right p-2" colspan="7" class="text-right">Total COD KHR: </td>
                                                        <td  class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"colspan="12">
                                                            {{ number_format($totalDriverKhr, 2) }}
                                                             <input name="driver_collect_khr" value="{{ $totalDriverKhr }}" type="hidden"/>
                                                        </td>
                                                    </tr>

                                                </tfoot>
                                            </table>

                                            </div>
                                        </div>
                                    </div>
                                 </div>

                               <div
                                    class="grid grid-cols-1 gap-6"
                                    x-data="paymentForm({{ isset($existingPayments) ? json_encode($existingPayments) : '[]' }}, {{ $remainingDriverUsd ?? 0 }}, {{ $remainingDriverKhr ?? 0 }})"
                                >
                                    <input type="hidden" name="delivery_by" value="{{ $deliveryBy->id }}">

                                    <!-- Cards + Payment Table -->
                                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">

                                        <!-- Summary Cards -->
                                        <div class="grid grid-cols-1 sm:grid-cols-3 lg:grid-cols-3 gap-4">
                                            <!-- Assigned -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100">{{ $statusCounts['assigned'] ?? $summary->assigned ?? 0 }}</p>
                                                    <i class="fas fa-truck text-primary dark:text-accent text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Assigned</p>
                                            </div>

                                            <!-- Success -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100">{{ $statusCounts['completed'] ?? $summary->completed ?? 0}}</p>
                                                    <i class="fas fa-check-circle text-green-500 text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Success</p>
                                            </div>

                                            <!-- Canceled -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100">{{ $statusCounts['canceled'] ?? $summary->canceled ?? 0}}</p>
                                                    <i class="fas fa-times-circle text-red-500 text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Canceled</p>
                                            </div>
                                        </div>

                                        <!-- Payment Table -->
                                        <div class="grid grid-cols-1 sm:grid-cols-1 lg:grid-cols-1 gap-4">
                                            <table class="rounded-lg min-w-full text-left border border-slate-300 dark:border-navy-500">
                                                <thead class="bg-slate-100 dark:bg-navy-600">
                                                    <tr>
                                                        <th class="p-3 whitespace-nowrap">Amount</th>
                                                        <th class="p-3 whitespace-nowrap">Currency</th>
                                                        <th class="p-3 whitespace-nowrap">Payment Method</th>
                                                    </tr>
                                                </thead>

                                                <tbody>
                                                    <template x-for="(payment, index) in payments" :key="index">
                                                        <tr class="border-t border-slate-200 dark:border-navy-500">
                                                            <!-- Amount -->
                                                            <td class="p-2">
                                                                <input
                                                                    type="number"
                                                                    step="0.01"
                                                                    :name="'payments['+index+'][amount]'"
                                                                    x-model="payment.amount"
                                                                    class="form-input w-full rounded border border-slate-300 px-3 py-2"
                                                                    placeholder="Amount"
                                                                >
                                                            </td>

                                                            <!-- Currency -->
                                                            <td class="p-2">
                                                                <select
                                                                    :name="'payments['+index+'][currency]'"
                                                                    x-model="payment.currency"
                                                                    class="form-select w-full rounded border border-slate-300 px-3 py-2"
                                                                >
                                                                    <option value="usd">USD</option>
                                                                    <option value="khr">KHR</option>
                                                                </select>
                                                            </td>

                                                            <!-- Payment Method -->
                                                            <td class="p-2">
                                                                <select
                                                                    :name="'payments['+index+'][payment_method]'"
                                                                    x-model="payment.payment_method"
                                                                    class="form-select w-full rounded border border-slate-300 px-3 py-2"
                                                                >
                                                                    <option value="cash">Cash</option>
                                                                    <option value="transfer">Transfer</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </template>
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>



                                <!-- Form Buttons -->
                                <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                                    <a href="{{ route('driver-collect-payment.index') }}"
                                        class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                                        Cancel
                                    </a>
                                    <button
                                        type="submit"
                                        class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2 flex items-center justify-center gap-2 disabled:opacity-70"
                                        :disabled="loading"
                                    >
                                        <!-- Spinner -->
                                        <svg
                                            x-show="loading"
                                            class="w-4 h-4 animate-spin text-white"
                                            xmlns="http://www.w3.org/2000/svg"
                                            fill="none"
                                            viewBox="0 0 24 24"
                                        >
                                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                            <path class="opacity-75" fill="currentColor"
                                                d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                                            </path>
                                        </svg>

                                        <!-- Text -->
                                        <span x-show="!loading">
                                            {{ isset($summary) ? 'Update Collect Payment' : 'Confirm Collect Payment' }}
                                        </span>
                                        <span x-show="loading">
                                            Processing...
                                        </span>
                                    </button>

                                </div>
                            </form>
                           
                        </div>
                    </div>


                </div>
            </div>
        </div>

             <!-- Payment Modal -->
    @include('pages.driver-collect-payment.payment-modal')

    </main>
</x-app-layout>


@stack('scripts')
<script>

    document.addEventListener('DOMContentLoaded', () => {
        document.querySelectorAll('.adjust-payment').forEach(button => {
            button.addEventListener('click', () => {
                const data = button.getAttribute('data-payment');

                try {
                    const parsed = JSON.parse(data);
                    window.dispatchEvent(new CustomEvent('open-status-modal', { detail: parsed }));
                } catch (e) {
                    alert('Failed to parse payment data');
                    console.error('Invalid JSON in data-payment:', data);
                }
            });
        });
    });





    function paymentForm(existingPayments = [], totalUsd = 0, totalKhr = 0) {
        return {
            payments: existingPayments.length
                ? existingPayments
                : [
                    { amount: totalUsd, currency: 'usd', payment_method: 'cash' },
                    { amount: totalKhr, currency: 'khr', payment_method: 'cash' }
                ],
            addRow() {
                this.payments.push({ amount: '', currency: 'usd', payment_method: 'cash' });
            },
            removeRow(index) {
                this.payments.splice(index, 1);
            }
        }
    }
</script>
