<x-app-layout title="Scan Assign" is-header-blur="false" is-sidebar-open="true" header-sticky="false" has-min-sidebar="false">
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">{{__('delivery.delivery')}}</h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">{{__('global.list')}}</a>
                    <svg x-ignore xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>{{__('scan_assign.scan_assign')}}</li>
            </ul>

            <!-- Back Button -->
            <div class="ml-auto">
                <a href="{{ route('delivery.index') }}" class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">{{ __('global.back') }}</a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
            <div>
                <div class="card p-2 mt-3">
                    


                    <div class="card">
                        <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 ">
                            <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
                           {{ __('scan_assign.scan') }}
                            </h2>
                        </div>

                        <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
                            <form method="POST" action="{{ route('scan-assign.store')}}" enctype="multipart/form-data" class="space-y-4" id="deliveryForm">
                                @csrf

                                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                                
                                
                                <div x-data>
                                    <label class="block">
                                        <span class="text-sm font-medium text-slate-700 dark:text-navy-100"> {{__('assign_driver.assign_to')}} <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <select  name="delivery_by" id="filterDriver"
                                        x-init="$nextTick(() => new TomSelect($el, {
                                            create: false,
                                            sortField: {
                                                field: 'text',
                                                direction: 'asc'
                                            },
                                            placeholder: '{{__('delivery.search_driver')}}',
                                            }))"
                                        class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                                        >
                                        <option value="">Select an driver</option>
                                        @foreach($deliveryBy as $id => $name)
                                                      <option value="{{ $id }}" {{ old('delivery_by') == $id ? 'selected' : '' }}>
                                                        {{ $name }}
                                                    </option>
                                                @endforeach
                                        </select>
                                    </label>
                                </div>



                                <div x-data>
                                    <label class="block">
                                        <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{__('scan_assign._scan')}}</span>
                                      
                                        <span class="relative mt-1.5 flex">
                                            <input  id="scanInput" name="code" value="{{ old('code') }}"
                                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                                placeholder="{{__('branch.enterBranchcode')}}" type="text" />
                                            <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                                <i class="fa fa-barcode text-base"></i>
                                            </span>
                                        </span>
                                    </label>
                                </div>


                                </div>
                                <hr/>

                                  <div class="w-full max-w-full px-0 mx-0">
                                     <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6 w-full">
                                        <div class="card p-2 mt-3">
                                            <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">
                                                 @if ($errors->any())
                                                    <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                                                        <ul>
                                                            @foreach ($errors->all() as $error)
                                                                <li>- {{ $error }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                @endif
                                                
                                                <table class="is-hoverable w-full text-left data-table">
                                                <thead>
                                                    <tr>
                                                        <th class="whitespace-nowrap bg-slate-200 px-2 py-2 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                                                        <label class="inline-flex items-center space-x-2">
                                                            <input
                                                            id="selectAll"
                                                            class="form-checkbox is-basic size-5 rounded bg-slate-100 border-slate-400/70 checked:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:bg-navy-900 dark:border-navy-500 dark:checked:bg-navy-400 dark:checked:border-navy-400"
                                                            type="checkbox"
                                                            />
                                                        </label>
                                                    </th>
                                                   <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                                        {{__('scan_assign.code')}}
                                                    </th>
                                                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                                        {{__('scan_assign.address')}}
                                                    </th>
                                                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                                        {{__('scan_assign.phone')}}
                                                    </th>
                                                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                                        {{__('delivery.amount_usd')}}
                                                    </th>
                                                  
                                                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                                        {{__('delivery.amount_khr')}}
                                                    </th>
                                                  
                                                    </tr>
                                                </thead>
                                                <tbody class="gridjs-tbody">
                                                
                                                </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                 </div>

                                <!-- Form Buttons -->
                                <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                                    <a href="{{ route('delivery.index') }}"
                                        class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                                        {{__('global.cancel')}}
                                    </a>
                                    <button type="submit"
                                        class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2">
                                        {{__('assign_driver.assign_driver')}}
                                    </button>
                                </div>
                            </form>
                           
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </main>
</x-app-layout>
@stack('scripts')
<script>
$('#selectAll').on('change', function () {
    let isChecked = $(this).is(':checked');
    $('input[name="delivery_ids[]"]').prop('checked', isChecked);
});

// Auto uncheck master checkbox if not all are selected
$(document).on('change', 'input[name="delivery_ids[]"]', function () {
    let total = $('input[name="delivery_ids[]"]').length;
    let checked = $('input[name="delivery_ids[]"]:checked').length;

    $('#selectAll').prop('checked', total === checked);
});

let table;

$(function () {
    table = $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('scan-assign.ajax') }}",
            data: function (d) {
                d.assign_to = $('#filterDriver').val();
            }
        },
        columns: [
           
             { data: 'delivery_id', name: 'delivery_id',
               render: function(data, type, row) {
                    return `<input type="checkbox" class="form-checkbox is-basic size-5 rounded bg-slate-100 border-slate-400/70 checked:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:bg-navy-900 dark:border-navy-500 dark:checked:bg-navy-400 dark:checked:border-navy-400" name="delivery_ids[]" value="${data}">`;
                },

                searchable: false,
                orderable: false
            },
            
            { data: 'code' },
            { data: 'receiver_address' },
            { data: 'receiver_phone' },
           {
                data: 'amount_usd', name: 'amount_usd',
                render: function(data) {
                    return new Intl.NumberFormat('en-US', {
                        style: 'currency',
                        currency: 'USD',
                    }).format(data);
                }
            },
            {
                data: 'amount_khr', name: 'amount_khr',
                render: function(data) {
                    return new Intl.NumberFormat('en-US', {
                        style: 'currency',
                        currency: 'KHR',
                    }).format(data);
                }
            },
        ],
          dom: "<'flex flex-col md:flex-row justify-between items-center mb-4'lf>tr<'flex flex-col md:flex-row justify-between items-center mt-4'ip>",
        language: {
            lengthMenu: "{{__('global.show')}} _MENU_ {{__('global.entry')}}",
            search: "{{__('global.search')}}",
            zeroRecords: "{{__('global.search_not_found')}}",
            info: "{{ __('global.showing') }} _START_ {{ __('global.To') }} _END_ {{ __('global.Of') }} _TOTAL_ {{ __('global.entry') }}",
            infoEmpty: "{{ __('global.showing') }} 0 {{ __('global.To') }} 0 {{ __('global.Of') }} 0 {{ __('global.entry') }}",
            infoFiltered: "({{ __('global.filter_from') }} _MAX_ {{ __('global.total_entries') }})",
             paginate: {
                 previous: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                    </svg>
                `,
                next: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                    </svg>
                `
            }
        },
         createdRow: function (row, data, dataIndex) {

            $(row).addClass(' hover:bg-slate-50 dark:hover:bg-navy-800');
            $('td', row).addClass('whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500');

        },
        drawCallback: function () {

            $('.dataTables_paginate .paginate_button')
            .addClass('flex mr-1 ml-1 h-8 min-w-[2rem] items-center justify-center bg-primary rounded-full bg-slate-150 px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90');

            $('.dataTables_paginate .paginate_button.previous, .dataTables_paginate .paginate_button.next')
                .addClass('flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90')
                .removeClass('px-3 min-w-[2rem]'); 

        }
    });

    $('.dataTables_filter input').addClass('form-input w-full rounded-full border border-slate-300 bg-transparent px-4 py-1 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_filter label').addClass('flex items-center space-x-2');
    $('.dataTables_length select').addClass('form-select rounded-full border border-slate-300 bg-white px-3 py-1 pr-6 text-xs-plus hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:text-navy-100 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_length label').addClass('flex items-center space-x-2');

});

$('#filterDriver').on('change', function () {
    table.ajax.reload(); // reload DataTable when driver changes
});

// Preload sounds
const successSound = new Audio("{{ asset('sounds/correct.mp3') }}");
const errorSound   = new Audio("{{ asset('sounds/scan.m4a') }}");

successSound.volume = 0.7;
errorSound.volume   = 0.7;

/* ==============================
   Scan Logic
================================ */
let scanning = false;

function processScan() {
    if (scanning) return;

    let code = $('#scanInput').val().trim();
    if (!code) return;

    let driver = $('#filterDriver').val();
    if (!driver) {
        alert('Please select driver first');
        $('#scanInput').focus();
        return;
    }

    scanning = true;

    $.ajax({
        url: "{{ route('scan.delivery') }}",
        type: "GET",
        data: {
            code: code,
            driver: driver
        },
        success: function (res) {
            if (res.success) {
                let exists = table.rows().data().toArray().some(r => r.id == res.data.id);
                if (exists) {
                    // Already scanned
                    errorSound.currentTime = 0;
                    errorSound.play().catch(()=>{});
                    $('#scanInput').val('').focus();
                    return;
                }
                // Add new row
                table.row.add(res.data).draw(false);
                // Success beep
                successSound.currentTime = 0;
                successSound.play().catch(()=>{});
                $('#scanInput').val('').focus();
            }
        },
        error: function (xhr) {
            errorSound.currentTime = 0;
            errorSound.play().catch(()=>{});
            $('#scanInput').val('').focus();
        },
        complete: function () {
            scanning = false;
        }
    });
}


// Scanner / Enter key
$('#scanInput').on('keydown', function (e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        processScan();
    }
});


// Auto focus scan input after driver select
$('#filterDriver').on('change', function () {
    $('#scanInput').focus();
});



</script>
