<x-app-layout
    title="Import Delivery"
    is-header-blur="false"
    is-sidebar-open="true"
    header-sticky="false"
    has-min-sidebar="false"
>
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <!-- Header -->
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                {{__('import_delivery.delivery')}}
            </h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary hover:text-primary-focus" href="#">{{__('global.list')}}</a>
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none"
                         viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round"
                              stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>{{__('import_delivery.delivery_import')}}</li>
            </ul>
        </div>

        <!-- Card -->
        <div class="grid grid-cols-1 gap-4">
            <div class="card p-6">
                <h3 class="text-lg font-semibold mb-4">
                    {{__('import_delivery.delivery_import')}} (Excel)
                </h3>

                <!-- Download template -->
                <a
                    href="{{ asset('templates/delivery_import_template.xlsx') }}"
                    download
                    class="btn bg-slate-200 hover:bg-slate-300 text-slate-800 flex items-center gap-2 mb-6"
                >
                    <svg class="w-4 h-4" fill="none" stroke="currentColor"
                         viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                              stroke-width="2"
                              d="M12 4v12m0 0l-4-4m4 4l4-4M4 20h16" />
                    </svg>
                    {{__('import_delivery.download_template')}}
                </a>

                <div id="errorBox" class="hidden mb-4 p-4 bg-red-100 text-red-700 rounded">
                    <ul id="errorList" class="list-disc list-inside"></ul>
                </div>


                <!-- Form -->
                <form id="importForm" enctype="multipart/form-data">
                    @csrf

                    <!-- Drop area -->
                    <div
                        id="dropArea"
                        class="flex flex-col items-center justify-center
                               border-2 border-dashed border-slate-300
                               rounded-lg p-8 text-center cursor-pointer
                               hover:border-primary transition"
                    >
                        <svg class="w-12 h-12 text-slate-400 mb-3"
                             fill="none" stroke="currentColor"
                             viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                  stroke-width="2"
                                  d="M7 16V4a1 1 0 011-1h8a1 1 0 011 1v12
                                     m-5-4l-4 4m0 0l-4-4m4 4V9" />
                        </svg>

                        <p class="text-slate-600">
                            {{__('import_delivery.drag_drop_file')}}
                            <span class="text-primary font-medium">browse</span>
                        </p>

                        <input
                            type="file"
                            name="file"
                            id="fileInput"
                            class="hidden"
                            accept=".xlsx,.xls,.csv"
                        >
                    </div>

                    <!-- File name -->
                    <p id="fileName"
                       class="mt-3 text-sm text-slate-500 hidden"></p>

                    <!-- Progress -->
                    <div class="mt-4 hidden" id="progressWrapper">
                        <div class="w-full bg-slate-200 rounded-full h-2">
                            <div id="progressBar"
                                 class="bg-primary h-2 rounded-full"
                                 style="width:0%"></div>
                        </div>
                        <p class="text-sm mt-2 text-slate-600"
                           id="progressText">
                            Uploading...
                        </p>
                    </div>

                    <!-- Submit -->
                    <div class="mt-6 flex justify-end">
                        <button
                            type="submit"
                            class="btn bg-primary text-white
                                   hover:bg-primary-focus flex items-center gap-2"
                        >
                            <svg id="loadingIcon"
                                 class="hidden animate-spin h-5 w-5"
                                 viewBox="0 0 24 24">
                                <circle cx="10" cy="10" r="10"
                                        stroke="currentColor"
                                        stroke-width="4"
                                        fill="none" />
                            </svg>
                            {{__('import_delivery.import')}}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </main>
</x-app-layout>

<!-- Axios -->
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script>
/* ===============================
   DOM ELEMENTS
================================ */
const dropArea = document.getElementById('dropArea');
const fileInput = document.getElementById('fileInput');
const fileName = document.getElementById('fileName');
const form = document.getElementById('importForm');

const progressWrapper = document.getElementById('progressWrapper');
const progressBar = document.getElementById('progressBar');
const progressText = document.getElementById('progressText');
const loadingIcon = document.getElementById('loadingIcon');

/* ===============================
   ERROR HANDLERS
================================ */
function showTextErrors(messages) {
    const box = document.getElementById('errorBox');
    const list = document.getElementById('errorList');

    list.innerHTML = '';

    messages.forEach(msg => {
        const li = document.createElement('li');
        li.textContent = msg;
        list.appendChild(li);
    });

    box.classList.remove('hidden');
}

function hideTextErrors() {
    document.getElementById('errorBox')?.classList.add('hidden');
}

/* ===============================
   DRAG & DROP
================================ */
dropArea.addEventListener('click', () => fileInput.click());

dropArea.addEventListener('dragover', e => {
e.preventDefault();
    dropArea.classList.add('border-primary');
});

dropArea.addEventListener('dragleave', () => {
    dropArea.classList.remove('border-primary');
});

dropArea.addEventListener('drop', e => {
    e.preventDefault();
    dropArea.classList.remove('border-primary');
    fileInput.files = e.dataTransfer.files;
    showFileName();
});

fileInput.addEventListener('change', showFileName);

function showFileName() {
    if (fileInput.files.length) {
        fileName.textContent = `Selected file: ${fileInput.files[0].name}`;
        fileName.classList.remove('hidden');
    }
}

/* ===============================
   FORM SUBMIT
================================ */
form.addEventListener('submit', function (e) {
    e.preventDefault();

    hideTextErrors();

    const formData = new FormData(this);

    progressWrapper.classList.remove('hidden');
    loadingIcon.classList.remove('hidden');
    progressBar.style.width = '0%';
    progressBar.classList.remove('bg-green-500');

    axios.post("{{ route('delivery.import') }}", formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        onUploadProgress(e) {
            if (!e.total) return;
            const percent = Math.round((e.loaded / e.total) * 60);
            progressBar.style.width = percent + '%';
            progressText.textContent = `Importing... ${percent}%`;
        }
    })

    /* ===== SUCCESS ===== */
    .then(res => {
        progressText.textContent = 'Import completed!';
        progressBar.style.width = '100%';
        progressBar.classList.add('bg-green-500');

        alert('Import success');

        setTimeout(() => {
            window.location.reload();
        }, 800);
    })


  .catch(err => {
        progressWrapper.classList.add('hidden');

        const errors =
            err.response?.data?.errors
                ? Object.values(err.response.data.errors).flat()
                : [err.response?.data?.message ?? 'Import failed'];

        showTextErrors(errors);
    })


    /* ===== FINALLY ===== */
    .finally(() => {
        loadingIcon.classList.add('hidden');
    });
});
</script>
