<div x-data="usePopper({placement:'bottom-end',offset:4})" @click.outside="if(isShowPopper) isShowPopper = false" class="inline-flex">
    <button x-ref="popperRef" @click="isShowPopper = !isShowPopper" class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z"></path>
        </svg>
    </button>

    <div x-ref="popperRoot" class="popper-root" :class="isShowPopper && 'show'">
        <div class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700">
            <ul>
                <li>
                    <a href="{{ route('customer.edit', $row->id) }}" class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide hover:bg-slate-100 dark:hover:bg-navy-600">
                        {{__('global.edit')}}
                    </a>
                </li>
                <li>
                    <a href="{{ route('customer.show', $row->id) }}" class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide hover:bg-slate-100 dark:hover:bg-navy-600">
                        {{__('customer.view')}}
                    </a>
                </li>
                <li>
                    <form method="POST" action="{{ route('admin.login-as-customer', $row->id) }}">
                        @csrf
                        <button type="submit" class="flex h-8 w-full items-center px-3 pr-8 font-medium tracking-wide hover:bg-slate-100 dark:hover:bg-navy-600 text-left">
                            {{__('customer.login_as_customer')}}
                        </button>
                    </form>
                </li>
            </ul>
        </div>
    </div>
</div>
