<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 ">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
            {{ isset($role) ? __('role_permission.edit_role_permission') : __('role_permission.create_role_and_permission') }}
        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="{{ isset($role) ? route('roles.update', $role->id) : route('roles.store') }}" enctype="multipart/form-data">
            @csrf
            @if(isset($role))
                @method('PUT')
            @endif

            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <label class="block">
                    <span>{{ __('role_permission.role') }}</span>
                    <span class="relative mt-1.5 flex">
                        <input name="name" value="{{ old('name', $role->name ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('role_permission.enter_role') }}" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-building text-base"></i>
                        </span>
                    </span>
                    @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

              

                {{-- Status --}}
                <label class="block">
                    <span>{{__('global.status')}}</span>
                    <span class="relative mt-1.5 flex">
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="status" type="radio" value="active" {{ old('status', $role->status ?? 'active') == 'active' ? 'checked' : '' }} />
                            <p>{{__('global.active')}}</p>
                        </label>
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="status" type="radio" value="inactive" {{ old('status', $role->status ?? '') == 'inactive' ? 'checked' : '' }} />
                            <p>{{__('global.inactive')}}</p>
                        </label>
                    </span>
                    @error('status') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

            </div>



            <div class="grid border-t mt-4 grid-cols-1 gap-4 sm:grid-cols-1">
                   <label class="block">
                        <div class="flex items-center justify-between mb-2 mt-4">
                            <span>{{ __('role_permission.choose_permission') }}<span class="text-red-500 text-xs">*</span></span>
                        </div>
                        <div class="">
                      
                                @php
                                    $groupedPermissions = $permissions->groupBy(function ($permission) {
                                        return explode('.', $permission->name)[0];
                                    });
                                @endphp

                                <div>
                                    @foreach($groupedPermissions as $module => $perms)
                                        <div class="mb-6 border p-3 rounded-lg dark:border-navy-500">
                                            <div class="flex items-center justify-between mb-2 border-b">
                                                <h3 class="text-lg font-semibold">{{ ucfirst($module) }}</h3>
                                                <label class="inline-flex items-center space-x-2 cursor-pointer">
                                                    <input
                                                        type="checkbox"
                                                        class="module-select-all form-checkbox size-5 border-slate-400 dark:border-navy-400"
                                                        data-module="{{ $module }}"
                                                    />
                                                    <span class="text-sm">Select All</span>
                                                </label>
                                            </div>

                                            <div class="grid grid-cols-4 sm:grid-cols-4 gap-4">
                                                @foreach($perms as $permission)
                                                    <label class="inline-flex items-center space-x-2">
                                                        <input
                                                            type="checkbox"
                                                            name="permissions[]"
                                                            value="{{ $permission->id }}"
                                                            class="permission-checkbox"
                                                            data-module="{{ $module }}"
                                                            {{ in_array($permission->id, old('permissions', $rolePermissions ?? [])) ? 'checked' : '' }}
                                                        />
                                                        <span>{{ ucfirst(explode('.', $permission->name)[1]) }}</span>
                                                    </label>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                        @error('permissions')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                        </div>
                    </label>
            </div>


            {{-- Buttons --}}
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="{{ route('roles.index') }}"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90">
                    {{__('global.cancel')}}
                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90 ml-2">
                    {{ isset($role) ? __('global.update') : __('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>


<script>
   document.addEventListener("DOMContentLoaded", function () {
    // Get all "Select All" module checkboxes
    const moduleSelectAllCheckboxes = document.querySelectorAll(".module-select-all");

    moduleSelectAllCheckboxes.forEach(moduleCheckbox => {
        const module = moduleCheckbox.dataset.module;

        // When the module "Select All" checkbox changes
        moduleCheckbox.addEventListener("change", () => {
            const permissionsInModule = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]`);
            permissionsInModule.forEach(cb => cb.checked = moduleCheckbox.checked);
        });

        // Sync "Select All" checkbox if all individual permissions are selected/deselected
        const permissionsInModule = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]`);
        permissionsInModule.forEach(cb => {
            cb.addEventListener("change", () => {
                const allChecked = [...permissionsInModule].every(c => c.checked);
                moduleCheckbox.checked = allChecked;
            });
        });

        // Initial sync on page load
        const allCheckedInit = [...document.querySelectorAll(`.permission-checkbox[data-module="${module}"]`)].every(c => c.checked);
        moduleCheckbox.checked = allCheckedInit;
    });
});

</script>
