<x-app-layout title="Branches" is-header-blur="false" is-sidebar-open="true" header-sticky="false" has-min-sidebar="false">



    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">Users</h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">List</a>
                    <svg x-ignore xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>Create</li>
            </ul>

            <!-- Back Button -->
            <div class="ml-auto">
                <a href="{{ route('users.index') }}" class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">Back</a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
            <div>
                <div class=" p-2 mt-3">
                   
                <div class="grid grid-cols-12 gap-4 sm:gap-5 lg:gap-6">
                    <div class="col-span-12 lg:col-span-4">
                        <div class="card p-4 sm:p-5">
                        <div class="flex items-center space-x-4 mb-4"> 
                            <div class="avatar size-14">
                            <img
                                class="rounded-full"
                                src="{{asset('images/200x200.png')}}"
                                alt="avatar"
                            />
                            </div>
                            <div>
                            <h3
                                class="text-base font-medium text-slate-700 dark:text-navy-100"
                            >
                                Travis Fuller
                            </h3>
                            <p class="text-xs-plus">Author</p>
                            </div>
                        </div>

                        <ol class="timeline max-w-sm">
                            <li class="timeline-item">
                            <div
                                class="timeline-item-point rounded-full bg-slate-300 dark:bg-navy-400"
                            ></div>
                            <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                <p
                                    class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                                >
                                    User Photo Changed
                                </p>
                                <span class="text-xs text-slate-400 dark:text-navy-300"
                                    >12 minute ago</span
                                >
                                </div>
                                <p class="py-1">John Doe changed his avatar photo</p>
                            </div>
                            </li>
                            <li class="timeline-item">
                            <div
                                class="timeline-item-point rounded-full bg-primary dark:bg-accent"
                            ></div>
                            <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                <p
                                    class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                                >
                                    Video Added
                                </p>
                                <span class="text-xs text-slate-400 dark:text-navy-300"
                                    >1 hour ago</span
                                >
                                </div>
                                <p class="py-1">Mores Clarke added new video</p>
                            </div>
                            </li>
                            <li class="timeline-item">
                            <div class="timeline-item-point rounded-full bg-success">
                                <span
                                class="inline-flex h-full w-full animate-ping rounded-full bg-success opacity-80"
                                ></span>
                            </div>
                            <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                <p
                                    class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                                >
                                    Design Completed
                                </p>
                                <span class="text-xs text-slate-400 dark:text-navy-300"
                                    >3 hours ago</span
                                >
                                </div>
                                <p class="py-1">
                                Robert Nolan completed the design of the CRM application
                                </p>
                            </div>
                            </li>
                            <li class="timeline-item">
                            <div class="timeline-item-point rounded-full bg-warning"></div>
                            <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                <p
                                    class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                                >
                                    ER Diagram
                                </p>
                                <span class="text-xs text-slate-400 dark:text-navy-300"
                                    >a day ago</span
                                >
                                </div>
                                <p class="py-1">Team completed the ER diagram app</p>
                            </div>
                            </li>
                            <li class="timeline-item">
                            <div class="timeline-item-point rounded-full bg-error"></div>
                            <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                <p
                                    class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                                >
                                    Weekly Report
                                </p>
                                <span class="text-xs text-slate-400 dark:text-navy-300"
                                    >a day ago</span
                                >
                                </div>
                                <p class="py-1">The weekly report was uploaded</p>
                            </div>
                            </li>
                        </ol>
                       
                        </div>
                    </div>
                    
                    <div class="col-span-12 lg:col-span-8">
                        <div class="card">
                        <div
                            class="flex flex-col items-center space-y-4 border-b border-slate-200 p-4 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 sm:px-5"
                        >
                            <h2
                            class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100"
                            >
                            Account Setting
                            </h2>
                            <div class="flex justify-center space-x-2">
                            <button
                                class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                            >
                                Cancel
                            </button>
                            <button
                                class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                            >
                                Save
                            </button>
                            </div>
                        </div>
                        <div class="p-4 sm:p-5">
                            <div class="flex flex-col">
                            <span
                                class="text-base font-medium text-slate-600 dark:text-navy-100"
                                >Avatar</span
                            >
                            <div class="avatar mt-1.5 size-20">
                                <img
                                class="mask is-squircle"
                                src="{{asset('images/200x200.png')}}"
                                alt="avatar"
                                />
                                <div
                                class="absolute bottom-0 right-0 flex items-center justify-center rounded-full bg-white dark:bg-navy-700"
                                >
                                <button
                                    class="btn size-6 rounded-full border border-slate-200 p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:border-navy-500 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                                >
                                    <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    class="size-3.5"
                                    viewBox="0 0 20 20"
                                    fill="currentColor"
                                    >
                                    <path
                                        d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z"
                                    />
                                    </svg>
                                </button>
                                </div>
                            </div>
                            </div>
                            <div class="my-7 h-px bg-slate-200 dark:bg-navy-500"></div>
                            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <label class="block">
                                <span>Display name </span>
                                <span class="relative mt-1.5 flex">
                                <input
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Enter name"
                                    type="text"
                                />
                                <span
                                    class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                                >
                                    <i class="fa-regular fa-user text-base"></i>
                                </span>
                                </span>
                            </label>
                            <label class="block">
                                <span>Full Name </span>
                                <span class="relative mt-1.5 flex">
                                <input
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Enter full name"
                                    type="text"
                                />
                                <span
                                    class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                                >
                                    <i class="fa-regular fa-user text-base"></i>
                                </span>
                                </span>
                            </label>
                            <label class="block">
                                <span>Email Address </span>
                                <span class="relative mt-1.5 flex">
                                <input
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Enter email address"
                                    type="text"
                                />
                                <span
                                    class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                                >
                                    <i class="fa-regular fa-envelope text-base"></i>
                                </span>
                                </span>
                            </label>
                            <label class="block">
                                <span>Phone Number</span>
                                <span class="relative mt-1.5 flex">
                                <input
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Enter phone number"
                                    type="text"
                                />
                                <span
                                    class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                                >
                                    <i class="fa fa-phone"></i>
                                </span>
                                </span>
                            </label>
                            </div>
                            <div class="my-7 h-px bg-slate-200 dark:bg-navy-500"></div>
                            <div>
                            <h3
                                class="text-base font-medium text-slate-600 dark:text-navy-100"
                            >
                                Linked Accounts
                            </h3>
                            <p class="text-xs-plus text-slate-400 dark:text-navy-300">
                                Lorem ipsum dolor sit amet consectetur.
                            </p>
                            <div class="flex items-center justify-between pt-4">
                                <div class="flex items-center space-x-4">
                                <div class="size-12">
                                    <img src="{{asset('images/logos/google.svg')}}" alt="logo" />
                                </div>
                                <p class="font-medium line-clamp-1">
                                    Sign In with Google
                                </p>
                                </div>
                                <button
                                class="btn h-8 rounded-full border border-slate-200 px-3 text-xs-plus font-medium text-primary hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-500 dark:text-accent-light dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90"
                                >
                                Connect
                                </button>
                            </div>
                            </div>
                        </div>
                        </div>
                    </div>
                    </div>


                </div>
            </div>
        </div>
    </main>
</x-app-layout>
