@php
    // Zones assigned to other drivers except current driver in edit mode
    $assignedZoneIds = \App\Models\AssignZone::when(isset($assingZone), function ($q) use ($assingZone) {
        return $q->where('driver_id', '!=', $assingZone->driver_id);
    })->pluck('zone_price_id')->toArray();

    // Selected zone IDs for checkboxes
    $selectedZoneIds = old('zone', isset($assingZones) ? $assingZones->flatMap->zonePrices->pluck('id')->toArray() : []);
@endphp

<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
            {{ isset($assingZone) ? 'Edit Assign & Zone' : __(('maping_zone.create_assign_zone')) }}
        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="{{ isset($assingZone) ? route('assignZones.update', $assingZone->driver_id) : route('assign-zones.store') }}" enctype="multipart/form-data">
            @csrf
            @if(isset($assingZone))
                @method('PUT')
            @endif

            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <div x-data>
                    <label class="block">
                        <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{ __('maping_zone.delivery_by') }}</span>
                        <select name="delivery_by" id="deliveryFilter"
                            x-init="$nextTick(() => new TomSelect($el, {
                                create: false,
                                sortField: { field: 'text', direction: 'asc' },
                                placeholder: '{{__('maping_zone.search_select_driver')}}...'
                            }))"
                            class="mt-1.5 w-full rounded-lg border-slate-300 dark:border-navy-450 dark:bg-navy-700"
                        >
                            <option value="">Select a driver</option>
                            @foreach($deliveryBy as $id => $name)
                                <option value="{{ $id }}" {{ old('delivery_by', $assingZone->driver_id ?? '') == $id ? 'selected' : '' }}>
                                    {{ $name }}
                                </option>
                            @endforeach
                        </select>
                    </label>
                </div>
            </div>

            <div class="grid border-t mt-4 grid-cols-3 gap-4 sm:grid-cols-3">
                <label class="block col-span-3">
                    <div class="flex items-center justify-between mb-2 mt-4">
                        <span>{{__('maping_zone.choose_zone')}} <span class="text-red-500 text-xs">*</span></span>
                    </div>

                    @foreach($zoneTypes as $module => $zone)
                        <div class="mb-6 border p-3 rounded-lg dark:border-navy-500">
                            <div class="flex items-center justify-between mb-2">
                                <h3 class="text-lg font-semibold">{{ $zone->zone_type }}</h3>
                                <label class="inline-flex items-center space-x-2 cursor-pointer">
                                    <input type="checkbox" class="module-select-all form-checkbox size-5 border-slate-400 dark:border-navy-400" data-module="{{ $module }}" />
                                    <span class="text-sm">{{ __('global.select_all') }}</span>
                                </label>
                            </div>

                            <div class="grid grid-cols-2">
                                @foreach($zone->zonePrices as $z)
                                    <label class="inline-flex items-center space-x-2">
                                        <input
                                            type="checkbox"
                                            name="zone[]"
                                            value="{{ $z->id }}"
                                            class="permission-checkbox"
                                            data-module="{{ $module }}"
                                            {{ in_array($z->id, $selectedZoneIds) ? 'checked' : '' }}
                                            {{ in_array($z->id, $assignedZoneIds) ? 'disabled' : '' }}
                                        />
                                        <span>
                                            {{ $z->zone_name }}
                                            @if(in_array($z->id, $assignedZoneIds))
                                                <span class="text-xs text-red-500">(Assigned)</span>
                                            @endif
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                    @endforeach

                    @error('zone')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </label>
            </div>

            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="{{ route('assign-zones.index') }}"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90">
                    {{__('global.cancel')}}
                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90 ml-2">
                    {{ isset($assingZone) ? 'Update' : __('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const moduleSelectAllCheckboxes = document.querySelectorAll(".module-select-all");

        moduleSelectAllCheckboxes.forEach(moduleCheckbox => {
            const module = moduleCheckbox.dataset.module;

            moduleCheckbox.addEventListener("change", () => {
                const permissionsInModule = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]:not(:disabled)`);
                permissionsInModule.forEach(cb => cb.checked = moduleCheckbox.checked);
            });

            const permissionsInModule = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]:not(:disabled)`);
            permissionsInModule.forEach(cb => {
                cb.addEventListener("change", () => {
                    const allChecked = [...permissionsInModule].every(c => c.checked);
                    moduleCheckbox.checked = allChecked;
                });
            });

            const allCheckedInit = [...permissionsInModule].every(c => c.checked);
            moduleCheckbox.checked = allCheckedInit;
        });
    });
</script>
