

    <div x-data="cancelModal()" x-init="init()" id="statusModal" x-cloak>

            <div
                class="fixed inset-0 z-100 flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                x-show="showModal" role="dialog" @keydown.window.escape="showModal = false" 
                x-transition:enter="ease-out" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            >
                <div
                    class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                    @click="showModal = false"
                    x-show="showModal"
                    x-transition:enter="ease-out"
                    x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100"
                    x-transition:leave="ease-in"
                    x-transition:leave-start="opacity-100"
                    x-transition:leave-end="opacity-0"
                ></div>

                <div
                    class="relative  w-full max-w-lg origin-top rounded-lg bg-white  dark:bg-navy-700 transition-all duration-300"
                    x-show="showModal"
                    x-transition:enter="ease-out"
                    x-transition:enter-start="opacity-0 scale-95"
                    x-transition:enter-end="opacity-100 scale-100"
                    x-transition:leave="ease-in"
                    x-transition:leave-start="opacity-100 scale-100"
                    x-transition:leave-end="opacity-0 scale-95"
                >
                   <div class="flex justify-between items-center mb-4 border-b border-slate-200 pb-4 dark:border-navy-500 
                      rounded px-4 py-3">
                        <h3 class="text-base font-medium text-slate-800 dark:text-navy-100">
                             <template x-if="mode === 'edit'">
                                <span>Edit Exchange Rate: #<span x-text="deliveryId"></span></span>
                            </template>
                            <template x-if="mode === 'create'">
                                <span>{{ __('exchange_rate.create_exchange_rate') }}</span>
                            </template>
                        </h3>
                        <button
                            @click="showModal = false"
                            class="btn -mr-1.5 rounded-full p-1 hover:bg-navy-200/20 focus:bg-navy-200/20 active:bg-navy-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                            aria-label="Close"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-navy-600 dark:text-navy-300" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>

                    <div class="p-4">
                       <div class="p-4 space-y-4">
                        <!-- Base Currency -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-slate-700 dark:text-navy-100">{{__('exchange_rate.base_currency')}}</label>
                            <select
                                x-model="form.currency_from"
                                class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                            >
                                <option value="">{{ __('exchange_rate.select_base') }}</option>
                                <option value="USD">USD</option>
                                <option value="KHR">KHR</option>
                            </select>
                        </div>

                        <!-- Target Currency -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-slate-700 dark:text-navy-100">{{__('exchange_rate.target_currency')}}</label>
                            <select
                                x-model="form.currency_to"
                                class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                            >
                                <option value="">{{ __('exchange_rate.select_target') }}</option>
                                <option value="USD">USD</option>
                                <option value="KHR">KHR</option>
                            </select>
                        </div>

                        <!-- Rate -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-slate-700 dark:text-navy-100">{{__('exchange_rate.exchange_rate')}}</label>
                            <input
                                type="number"
                                step="0.0001"
                                x-model="form.rate"
                                class="form-input mt-1.5 w-full rounded border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                placeholder="e.g., 4100"
                            >
                        </div>

                    </div>


                    </div>

                   <div class="flex p-4 justify-end space-x-2 border-t border-slate-200 pt-4 dark:border-navy-500 mt-4">
                    <!-- Close Button -->
                    <button type="button"
                        @click="showModal = false"
                        class="btn border border-primary/30 bg-primary/10 font-medium text-primary 
                            hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 
                            dark:border-accent-light/30 dark:bg-accent-light/10 
                            dark:text-accent-light dark:hover:bg-accent-light/20 
                            dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25">
                        {{__('exchange_rate.close')}}
                    </button>

                    <!-- Save/Create Button -->
                    <button v-if="mode === 'edit' || mode === 'create'" type="button"
                        @click="submitPayment()"
                        class="btn border border-primary/30 bg-primary/10 font-medium text-primary 
                            hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 
                            dark:border-accent-light/30 dark:bg-accent-light/10 
                            dark:text-accent-light dark:hover:bg-accent-light/20 
                            dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25">
                        <span x-text="mode === 'edit' ? 'Save' : '{{__('global.save')}}'"></span>
                    </button>
                </div>


                </div>
            </div>
        </div>

       <script>
function cancelModal() {
    return {
        showModal: false,
        deliveryId: null,
        form: {
            currency_from: '',
            currency_to: '',
            rate: '',
        },
        mode: 'create',

        init() {
            window.addEventListener('addNew', (event) => {
                console.log(event.detail);
                this.showModal = true;
                this.deliveryId = event.detail.deliveryId;
                this.form.currency_from = event.detail.currency_from || '';
                this.form.currency_to = event.detail.currency_to || '';
                this.form.rate = event.detail.rate || '';
                this.mode = event.detail.mode || 'create';
            });
        },

        resetForm() {
            this.deliveryId = null;
            this.form.currency_from = '';
            this.form.currency_to = '';
            this.form.rate = '';
            this.mode = 'create';
        },

       submitPayment() {
            if (!this.form.currency_from || !this.form.currency_to || !this.form.rate) {
                alert('Please fill in all required fields.');
                return;
            }

            const payload = {
                currency_from: this.form.currency_from,
                currency_to: this.form.currency_to,
                rate: this.form.rate,
                id: this.deliveryId, // optional for update
            };

        const storeUrl = "{{ route('global-exchange-rate.store') }}";
        const updateUrl = "{{ route('global-exchange-rate.update', ['global_exchange_rate' => '__ID__']) }}";
        const url = this.mode === 'edit'
            ? updateUrl.replace('__ID__', this.deliveryId)
            : storeUrl;
                
           fetch(url, {
               method: this.mode === 'edit' ? "PATCH" : "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": "{{ csrf_token() }}",
                },
                body: JSON.stringify(payload),
            })
            .then(async (response) => {
                let data;
                try {
                    data = await response.json();
                } catch (err) {
                    throw new Error('Error parsing response');
                }

                if (response.ok && data.success) {
                    this.showModal = false;
                    this.resetForm();
                    $('.data-table').DataTable().ajax.reload(null, false);
                    alert(data.message || 'Exchange rate saved successfully.');
                } else {
                    alert(data.message || 'Failed to save exchange rate.');
                }
            })
            .catch(() => {
                alert('Server error occurred.');
            });
        },

    };
}

</script>
