<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 ">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
            {{ isset($branch) ? __('branch.editBranch') : __('branch.createBranch') }}
        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="{{ isset($branch) ? route('branch.update', $branch->id) : route('branch.store') }}" enctype="multipart/form-data">
            @csrf
            @if(isset($branch))
                @method('PUT')
            @endif

            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                {{-- Branch Name --}}
                <label class="block">
                    <span>{{ __('branch.branchName') }}</span>
                    <span class="relative mt-1.5 flex">
                        <input name="name" value="{{ old('name', $branch->name ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('branch.enterBranch') }}" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-building text-base"></i>
                        </span>
                    </span>
                    @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                {{-- Short Name --}}
                <label class="block">
                    <span>{{ __('branch.shortName') }}</span>
                    <span class="relative mt-1.5 flex">
                        <input name="short_name" value="{{ old('short_name', $branch->short_name ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('branch.enterShortname') }}" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-building text-base"></i>
                        </span>
                    </span>
                    @error('short_name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                {{-- Type --}}
                <label class="block">
                    <span>{{__('branch.type')}}</span>
                    <span class="relative mt-1.5 flex">
                        <input name="type" value="{{ old('type', $branch->type ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('branch.enterType') }}" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa fa-tag text-base"></i>
                        </span>
                    </span>
                    @error('type') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                {{-- Status --}}
                <label class="block">
                    <span>{{__('global.status')}}</span>
                    <span class="relative mt-1.5 flex">
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="status" type="radio" value="active" {{ old('status', $branch->status ?? 'active') == 'active' ? 'checked' : '' }} />
                            <p>{{__('global.active')}}</p>
                        </label>
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="status" type="radio" value="inactive" {{ old('status', $branch->status ?? '') == 'inactive' ? 'checked' : '' }} />
                            <p>{{ __('global.inactive') }}</p>
                        </label>
                    </span>
                    @error('status') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                {{-- Code --}}
                <label class="block">
                    <span>{{ __('branch.branchCode') }}</span>
                    <span class="relative mt-1.5 flex">
                        <input name="code" value="{{ old('code', $branch->code ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('branch.enterBranchcode') }}" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa fa-barcode text-base"></i>
                        </span>
                    </span>
                    @error('code') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                {{-- Logo --}}
                <label class="block">
                    <span>{{ __('branch.branchLogo') }}</span>
                    <input name="logo" type="file"
                        class="form-input mt-1.5 w-full rounded-full border border-slate-300 bg-white px-4 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent" />
                  
                        @if(isset($branch) && $branch->logo)
                            <img src="{{ asset('storage/' . $branch->logo) }}" alt="Branch Logo" class="w-20 h-20 mt-2 rounded">
                        @endif
                    @error('logo') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                {{-- Address --}}
                <label class="block sm:col-span-2">
                    <span>{{__('global.address')}}</span>
                    <textarea name="address"
                        class="form-input peer mt-1.5 w-full rounded border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                        placeholder="{{ __('global.enterAddress') }}">{{ old('address', $branch->address ?? '') }}</textarea>
                    @error('address') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                {{-- Phone --}}
                <label class="block">
                    <span>{{ __('global.phoneNumber') }}</span>
                    <span class="relative mt-1.5 flex">
                        <input name="phone" value="{{ old('phone', $branch->phone ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('branch.enterPhoneNum') }}" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa fa-phone text-base"></i>
                        </span>
                    </span>
                    @error('phone') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                {{-- Email --}}
                <label class="block">
                    <span>{{ __('branch.email') }}</span>
                    <span class="relative mt-1.5 flex">
                        <input name="email" value="{{ old('email', $branch->email ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('branch.enterEmail') }}" type="email" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-envelope text-base"></i>
                        </span>
                    </span>
                    @error('email') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>
            </div>

                {{-- URL --}}
            <label class="block">
                <span>{{__('branch.url')}}</span>
                <span class="relative mt-1.5 flex">
                    <input name="url" value="{{ old('url', $branch->url ?? '') }}"
                        class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                        placeholder="{{ __('branch.enterURL') }}" type="text" />
                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                        <i class="fa fa-globe"></i>
                    </span>
                </span>
                @error('url') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            </label>

            {{-- Buttons --}}
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="{{ route('branch.index') }}"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90">
                    {{ __('global.cancel') }}
                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90 ml-2">
                    {{ isset($branch) ? __('global.update') : __('global.save') }}
                </button>
            </div>

         

        </form>
    </div>
</div>
