<x-app-layout title="Booking" is-header-blur="false" is-sidebar-open="true" header-sticky="true" has-min-sidebar="false">

     <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                {{ __('booking.booking') }}
            </h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a
                        class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent"
                        href="#"
                    >{{__('global.list')}}</a>
                    <svg
                        x-ignore
                        xmlns="http://www.w3.org/2000/svg"
                        class="size-4"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                    >
                        <path
                            stroke-linecap="round"
                            stroke-linejoin="round"
                            stroke-width="2"
                            d="M9 5l7 7-7 7"
                        />
                    </svg>
                </li>
                <li>{{__('global.all')}}</li>
            </ul>

            <!-- Add New Button -->
            <div class="ml-auto">
                <!--Create Booking -->
                <a href="{{ route('booking-order.index') }}">
                    <div class="badge p-2 space-x-2 bg-blue-100 text-blue-800 dark:bg-blue-500 dark:text-white">
                        <i class="fas fa-user-plus"></i>
                        <span>{{ __('booking.create_booking') }}</span>
                    </div>
                </a>

             
                <a href="{{ route('transit.index') }}">
                    <div class="badge p-2 space-x-2 bg-purple-100 text-purple-800 dark:bg-purple-500 dark:text-white">
                        <i class="fas fa-people-arrows"></i>
                        <span>{{ __('booking.transit') }}</span>
                    </div>
                </a>


                
                <!-- <a href="{{ route('remove-delivery.index') }}">
                    <div class="badge p-2 space-x-2 bg-red-100 text-red-800 dark:bg-red-500 dark:text-white">
                        <i class="fas fa-trash"></i>
                        <span>Remove Delivery</span>
                    </div>
                </a> -->

            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-3 lg:grid-cols-6 gap-4 mt-4 card p-2">
            <div x-data="{ dateValue: '' }">
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{__('booking.entry_date')}}</span>
                    <label class="relative flex mt-1.5">
                        <input
                            id="entryFilter"
                            name="entry_at"
                            x-model="dateValue"
                            x-init="
                                flatpickr($el, {
                                    mode: 'range',
                                    dateFormat: 'Y-m-d',
                                    defaultDate: null,
                                    onChange: function(selectedDates, dateStr, instance) {
                                        dateValue = dateStr;
                                    }
                                });
                            "
                            class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 pr-10 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('booking.choose_date') }}"
                            type="text"
                            x-ref="entryDateInput"
                        />

                        <span
                            class="pointer-events-none absolute left-0 flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="size-5 transition-colors duration-200" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </span>

                        <button
                            type="button"
                            x-show="dateValue"
                            @click="dateValue = ''; $refs.entryDateInput._flatpickr.clear()"
                            class="absolute right-2 top-2 text-slate-400 hover:text-red-500 focus:outline-none"
                            title="Clear"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </label>
                </label>
            </div>


            <div x-data="{ dateValue: '' }">
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{__('booking.complete_date')}}</span>
                    <label class="relative flex mt-1.5">
                        <input
                            id="completedFilter"
                            name="completed_at"
                            x-model="dateValue"
                            x-init="
                                flatpickr($el, {
                                    mode: 'range',
                                    dateFormat: 'Y-m-d',
                                    defaultDate: null,
                                    onChange: function(selectedDates, dateStr, instance) {
                                        dateValue = dateStr;
                                    }
                                });
                            "
                            class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 pr-10 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('booking.choose_date') }}"
                            type="text"
                            x-ref="entryDateInput"
                        />

                        <span
                            class="pointer-events-none absolute left-0 flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="size-5 transition-colors duration-200" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </span>

                        <button
                            type="button"
                            x-show="dateValue"
                            @click="dateValue = ''; $refs.entryDateInput._flatpickr.clear()"
                            class="absolute right-2 top-2 text-slate-400 hover:text-red-500 focus:outline-none"
                            title="Clear"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </label>
                </label>
            </div>



            <div x-data>
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{__('booking.from_warehouse')}}</span>
                    <select name="from_warehouse" id="fromWarehouseFilter"
                        x-init="$nextTick(() => new TomSelect($el, {
                            create: false,
                            sortField: {
                                field: 'text',
                                direction: 'asc'
                            },
                            placeholder: '{{__('global.search')}}',
                            }))"
                        class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                        >
                        <option value="">from warehouse</option>
                        @foreach($warehouse as $id => $name)
                                <option value="{{ $id }}" {{ old('from_warehouse') == $id ? 'selected' : '' }}>
                                {{ $name }}
                            </option>
                        @endforeach
                    </select>
                </label>
            </div>
            

            <div x-data>
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{ __('booking.customer_name') }}</span>
                    <select id="customerFilter"  name="customer_id"
                        x-init="$nextTick(() => new TomSelect($el, {
                            create: false,
                            sortField: {
                                field: 'text',
                                direction: 'asc'
                            },
                            placeholder: '{{__('booking.search_select_customer')}}',
                            }))"
                        class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                        >
                        <option value="">Select an customer</option>
                        @foreach($customer as $customerOption)
                                    <option value="{{ $customerOption->id }}" {{ old('customer_id') == $customerOption->id ? 'selected' : '' }}>
                                    {{ $customerOption->customer_name }} {{ $customerOption->phone }}
                                </option>
                            @endforeach
                    </select>
                </label>
            </div>
            


            <div x-data>
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{__('booking.delivery_status')}}</span>
                    <select name="status" id="statusFilter"
                        x-init="$nextTick(() => new TomSelect($el, {
                            create: false,
                            sortField: {
                                field: 'text',
                                direction: 'asc'
                            },
                            placeholder: '{{__('booking.search_select_status')}}',
                            }))"
                        class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                        >
                        <option value="">Select an delivery status</option>
                        @foreach ($statusOptions as $option)
                                <option value="{{ $option['value'] }}" {{ old('status_id') == $option['value'] ? 'selected' : '' }}>
                                    {{ $option['label'] }}
                                </option>
                            @endforeach
                    </select>
                </label>
            </div>
        
        </div>
        

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">

          <div>
            <div class="card p-2 mt-3">
              <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left data-table">
                  <thead>
                    <tr>
                      <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-2 py-2 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('global.no')}}</th>
                         <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.photo')}}
                      </th>
                    <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.refcod')}}
                      </th>
                        <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.date')}}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.from_warehouse')}}
                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.import_by')}}
                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.tracking')}}
                      </th>
                        <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.kg')}}
                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.pcs')}}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.amount')}}
                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{ __('booking.to_warehouse') }}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('booking.local_tracking')}}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('global.status')}}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                       {{__('booking.entry_by')}}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                       {{__('booking.delivery_by')}}
                      </th>
                      <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('global.action')}}</th>
                    </tr>
                  </thead>
                  <tbody class="gridjs-tbody">
                   
                  </tbody>
                </table>
              </div>

          
            </div>
          </div>

        </div>


    @include('pages.booking.booking-modal')

  @include('pages.booking.popup-image')
    
      </main>
</x-app-layout>



@stack('scripts')
<script>
$(function () {
    $('.data-table').DataTable({
        scrollY: '400px',         // Scrollable body
        scrollCollapse: true,     // Collapse empty space
        fixedHeader: true, 
        processing: true,
        serverSide: true,
        responsive: true,
        autoWidth: false,
        scrollX: true,
        order: [[0, 'desc']],
        pageLength: 100,
        lengthMenu: [10, 25, 50, 100,200],
        searching: true,
        ajax: {
            url: "{{ route('bookingAjax') }}",
            data: function (d) {
                d.completed_at = $('#completedFilter').val();
                d.entry_at = $('#entryFilter').val();
                d.from_warehouse = $('#fromWarehouseFilter').val();
                d.customer_id = $('#customerFilter').val();
                d.status = $('#statusFilter').val();
            }
        },
        
        columns: [
            { data: 'id', name: 'id' },
            {
                data: 'photo',
                name: 'photo',
                orderable: false,
                searchable: false,
                render: function (data) {
                    if (!data) {
                        return '<span class="text-slate-400">No Photo</span>';
                    }

                    return `
                        <img 
                            src="${data}" 
                            class="photo-thumb cursor-pointer"
                            onclick="openPhotoModal('${data}')"
                        />
                    `;
                }
            },


            { data: 'ref_code', name: 'ref_code' },
            { data: 'created_at', name: 'created_at' },
            { data: 'from_warehouse_name', name: 'from_warehouse_name' },
            { data: 'shipping_method', name: 'shipping_method' },
            { data: 'tracking_number', name: 'tracking_number' },
            { data: 'kg', name: 'kg' },
            { data: 'pcs', name: 'pcs' },
            {
                data: 'amount_usd', name: 'amount_usd',
                render: function(data) {
                    return new Intl.NumberFormat('en-US', {
                        style: 'currency',
                        currency: 'USD',
                    }).format(data);
                }
            },
            { data: 'to_warehouse_name', name: 'to_warehouse_name' },
            { data: 'local_tracking', name: 'local_tracking' },
           
            {
                data: 'status_label',
                name: 'status_label',
                render: function (data, type, row) {
                    const isClickable = (row.status !== ('arrived_cn' || 'arrived_pp'));
                    const cursorClass = isClickable ? 'cursor-pointer' : 'cursor-not-allowed opacity-50';

                    const deliveryId = row.id;
                    const note = JSON.stringify(row.note || '');
                    const statusId = JSON.stringify(row.status || '');

                    const onclick = isClickable
                        ? `window.dispatchEvent(new CustomEvent('open-status-cancel-modal', { detail: { deliveryId: ${deliveryId}, note: ${note}, statusId: ${statusId} }}))`
                        : `alert('This recorde already arrived warehouse, Please process transit.')`;

                    return `
                        <div 
                            class="${cursorClass}" 
                            style="white-space: nowrap"
                            onclick="${onclick.replace(/"/g, '&quot;')}"
                        >
                            ${data}
                        </div>
                    `;
                }
            },

                
            { data: 'created_by', name: 'created_by' },
            { data: 'truck_by', name: 'truck_by' },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
        dom: "<'flex flex-col md:flex-row justify-between items-center mb-4'lf>tr<'flex flex-col md:flex-row justify-between items-center mt-4'ip>",
        language: {
            lengthMenu: "{{__('global.show')}} _MENU_ {{__('global.entry')}}",
            search: "{{__('global.search')}}",
            zeroRecords: "{{__('global.search_not_found')}}",
            info: "{{ __('global.showing') }} _START_ {{ __('global.To') }} _END_ {{ __('global.Of') }} _TOTAL_ {{ __('global.entry') }}",
            infoEmpty: "{{ __('global.showing') }} 0 {{ __('global.To') }} 0 {{ __('global.Of') }} 0 {{ __('global.entry') }}",
            infoFiltered: "({{ __('global.filter_from') }} _MAX_ {{ __('global.total_entries') }})",
             paginate: {
                 previous: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                    </svg>
                `,
                next: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                    </svg>
                `
            }
        },
         createdRow: function (row, data, dataIndex) {

            $(row).addClass(' hover:bg-slate-50 dark:hover:bg-navy-800');
            $('td', row).addClass('whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500');

        },
        drawCallback: function () {

            $('.dataTables_paginate .paginate_button')
            .addClass('flex mr-1 ml-1 h-8 min-w-[2rem] items-center justify-center bg-primary rounded-full bg-slate-150 px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90');

            $('.dataTables_paginate .paginate_button.previous, .dataTables_paginate .paginate_button.next')
                .addClass('flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90')
                .removeClass('px-3 min-w-[2rem]'); 

        }
    });

    $('.dataTables_filter input').addClass('form-input w-full rounded-full border border-slate-300 bg-transparent px-4 py-1 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_filter label').addClass('flex items-center space-x-2');
    $('.dataTables_length select').addClass('form-select rounded-full border border-slate-300 bg-white px-3 py-1 pr-6 text-xs-plus hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:text-navy-100 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_length label').addClass('flex items-center space-x-2');


});
$('#entryFilter, #completedFilter, #fromWarehouseFilter, #customerFilter, #statusFilter').on('change', function () {
    $('.data-table').DataTable().ajax.reload();
});

</script>
