<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Collect Payment With Driver','isHeaderBlur' => 'false','isSidebarOpen' => 'false','headerSticky' => 'false','hasMinSidebar' => 'false']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Collect Payment With Driver','is-header-blur' => 'false','is-sidebar-open' => 'false','header-sticky' => 'false','has-min-sidebar' => 'false']); ?>
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">Collect Payment</h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">List</a>
                    <svg x-ignore xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>driver</li>
            </ul>

            <!-- Back Button -->
            <div class="ml-auto">
  
                <a href="<?php echo e(route('driver-payment.index')); ?>" class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">Back</a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
            <div>
                <div class="card p-2 mt-3">
                    
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
                        <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                            <ul>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>- <?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                

                    <div class="card">
                        <div class="border border-slate-200 p-2 dark:border-navy-500">
                            <form method="POST"
                                action="<?php echo e(isset($summary) ? route('driver-collect-payment.update', $summary->id) : route('driver-collect-payment.store')); ?>"
                                enctype="multipart/form-data" class="space-y-4"
                                id="deliveryForm"
                                x-data="{ loading: false }"
                                @submit="loading = true">
                                <?php echo csrf_field(); ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($summary)): ?>
                                    <?php echo method_field('PUT'); ?>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                
                                  <div class="w-full max-w-full px-0 mx-0">
                                     <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6 w-full">
                                        <div class="card p-2">
                                            <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">

                                                <div class="mb-6 p-4 border border-slate-300 dark:border-navy-600 rounded bg-slate-50 dark:bg-navy-700">
                                                    <h2 class="text-xl text-center border-b border-slate-300 font-bold mb-4 text-slate-800 dark:text-navy-100">Driver Payment Invoice</h2>
                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div class="text-slate-700 dark:text-navy-100">
                                                            <p><span class="font-semibold">Driver Name:</span> <?php echo e($driverName); ?></p>
                                                            <p><span class="font-semibold">Exchange Rate:</span> 1 USD = <?php echo e(number_format($exchangeRate, 0)); ?> KHR</p>
                                                        </div>
                                                        <div class="text-right text-slate-700 dark:text-navy-100">
                                                            <p><span class="font-semibold">Invoice No:</span> <?php echo e($invoiceNumber); ?></p>
                                                            <p><span class="font-semibold">Print Date:</span> <?php echo e(now()->format('d-m-Y H:i:s')); ?></p>
                                                        </div>
                                                    </div>
                                                </div>


                                            <?php
                                                // Initialize Totals
                                                $totalDriverUsd = 0;
                                                $totalDriverKhr = 0;
                                                $totalShopUsd = 0;
                                                $totalShopKhr = 0;
                                                $totalCompanyUsd = 0;
                                                $totalCompanyKhr = 0;
                                                $totalDeliveryFee = 0;
                                                $totalAmountUsd = 0;
                                                $totalAmountKhr = 0;
                                                $totalAnyExtraFee = 0;
                                                
                                                // Initialize final payment amounts
                                                $totalDriverPayUsd = 0;
                                                $totalDriverPayKhr = 0;
                                            ?>

                                            <table class="is-hoverable w-full text-left data-table border border-collapse border-slate-300 ">

                                                <thead>
                                                    <tr>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">N<sup>o</sup></th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Customer</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Address</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Phone</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Entry</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Completed</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">COD</th>
                                                        <th colspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Driver</th>
                                                        <th colspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Shop</th>
                                                        <th colspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Company</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">ExtraFee</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Fee</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Total(USD)</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Total(KHR)</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Status</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">Action</th>
                                                    </tr>
                                                    <tr>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">USD</th>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">KHR</th>

                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">USD</th>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">KHR</th>

                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">USD</th>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">KHR</th>
                                                    </tr>
                                                </thead>

                                                <tbody class="gridjs-tbody">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $driverUsd = $delivery->payments->where('payment_to', 'driver')->where('currency', 'usd')->sum('amount');
                                                            $driverKhr = $delivery->payments->where('payment_to', 'driver')->where('currency', 'khr')->sum('amount');

                                                            $shopUsd = $delivery->payments->where('payment_to', 'shop')->where('currency', 'usd')->sum('amount');
                                                            $shopKhr = $delivery->payments->where('payment_to', 'shop')->where('currency', 'khr')->sum('amount');

                                                            $companyUsd = $delivery->payments->where('payment_to', 'company')->where('currency', 'usd')->sum('amount');
                                                            $companyKhr = $delivery->payments->where('payment_to', 'company')->where('currency', 'khr')->sum('amount');
                                                            
                                             
                                                         
                                                         $totalAnyExtraFee = $delivery->who_pay_fee === 'Driver' ? $delivery->any_extra_fee : 0;

                                                           // Accumulate totals
                                                            $totalDriverUsd += $driverUsd;
                                                            $totalDriverKhr += $driverKhr;


                                                           // Calculate remaining balances (do not overwrite original totals)
                                                            $remainingDriverUsd = $totalDriverUsd;
                                                            $remainingDriverKhr = $totalDriverKhr;

                                                            if ($totalDriverKhr == 0) {
                                                                // Only USD is available, deduct from USD
                                                                $remainingDriverUsd = $totalDriverUsd - $totalAnyExtraFee;
                                                            } else {
                                                                if ($totalDriverUsd >= $totalAnyExtraFee) {
                                                                    // USD covers all
                                                                    $remainingDriverUsd = $totalDriverUsd - $totalAnyExtraFee;
                                                                } else {
                                                                    // Partial USD, rest from KHR
                                                                    $remainingUsd = $totalAnyExtraFee - $totalDriverUsd;
                                                                    $deductKhr = $remainingUsd * $exchangeRate;

                                                                    $remainingDriverUsd = 0;
                                                                    $remainingDriverKhr = $totalDriverKhr - $deductKhr;
                                                                }
                                                            }




                                                            $totalShopUsd += $shopUsd;
                                                            $totalShopKhr += $shopKhr;

                                                            $totalCompanyUsd += $companyUsd;
                                                            $totalCompanyKhr += $companyKhr;

                                                            $totalDeliveryFee += $delivery->delivery_price;
                                                            $totalAmountUsd += $delivery->amount_usd;
                                                            $totalAmountKhr += $delivery->amount_khr;
                                                        ?>
                                                        <tr>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e($index + 1); ?>

                                                                 <input type="hidden" name="delivery_ids[]" value="<?php echo e($delivery->id); ?>">
                                                            </td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e($delivery->customer->customer_name ?? '-'); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e($delivery->receiver_address ?? '-'); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e($delivery->receiver_phone ?? '-'); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(\Carbon\Carbon::parse($delivery->pickup_at)->format('d-m-Y')); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500">
                                                                <?php echo e($delivery->completed_at ? \Carbon\Carbon::parse($delivery->completed_at)->format('d-m-Y') : '-'); ?>

                                                            </td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e($delivery->type_of_cod); ?></td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($driverUsd, 2)); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($driverKhr, 0)); ?></td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($shopUsd, 2)); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($shopKhr, 0)); ?></td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($companyUsd, 2)); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($companyKhr, 0)); ?></td>
                                                            <?php 
                                                                $extraFee = $delivery->any_extra_fee ?? 0;
                                                                $extraFeeUsd = ($delivery->who_pay_fee === 'Driver') ? $extraFee : 0;
                                                            ?>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($extraFeeUsd, 2)); ?></td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($delivery->delivery_price, 2)); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($delivery->amount_usd, 2)); ?></td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(number_format($delivery->amount_khr, 0)); ?></td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"><?php echo e(ucfirst($delivery->status)); ?></td>
                                                           
                                                             <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500 text-center">
                                                            <?php
                                                                $paymentData = [
                                                                    'deliveryId' => $delivery->id,
                                                                    'deliveryFee' => $delivery->delivery_price,
                                                                    'customerName' => $delivery->customer->customer_name,
                                                                    'amountUsd' => (float) $delivery->amount_usd,
                                                                    'amountKhr' => (float) $delivery->amount_khr,
                                                                    'note' => $delivery->note,
                                                                    'payments' => $delivery->payments->map(function ($p) {
                                                                        return [
                                                                            'payment_to' => $p->payment_to,
                                                                            'amount' => (float) $p->amount,
                                                                            'currency' => $p->currency,
                                                                            'payment_method' => $p->payment_method,
                                                                        ];
                                                                    })->values()->all(),
                                                                ];
                                                            ?>

                                                            <div
                                                                class="adjust-payment"
                                                                x-data
                                                                data-payment='<?php echo json_encode($paymentData, 15, 512) ?>'
                                                            >
                                                            <span  class="badge cursor-pointer space-x-2.5 rounded-full bg-warning/10 text-warning dark:bg-warning/15">
                                                                Adjust
                                                            </span>
                                                            </div>

                                                            </td>
                                                            
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </tbody>

                                                <tfoot>
                                                    <tr class="font-bold bg-slate-100 dark:bg-navy-700">
                                                        <td class="text-right p-2" colspan="7">Total: </td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalDriverUsd, 2)); ?></td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalDriverKhr, 0)); ?></td>

                                                        
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalShopUsd, 2)); ?></td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalShopKhr, 0)); ?></td>

                                                        
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalCompanyUsd, 2)); ?></td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalCompanyKhr, 0)); ?></td>

                                                        
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalAnyExtraFee, 2)); ?></td>

                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalDeliveryFee, 2)); ?></td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalAmountUsd, 2)); ?></td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ><?php echo e(number_format($totalAmountKhr, 0)); ?></td>

                                                        
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ></td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" ></td>
                                                    </tr>

                                                     <tr class="font-bold bg-slate-100 dark:bg-navy-700">
                                                        <td  class="text-right p-2" colspan="7" class="text-right">Other Extra Fee USD: </td>
                                                        <td  class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500" colspan="12"><?php echo e(number_format($totalAnyExtraFee, 2)); ?></td>
                                                    </tr>
                                                    <tr class="font-bold bg-slate-100 dark:bg-navy-700">
                                                        <td  class="text-right p-2" colspan="7" class="text-right">Total COD USD: </td>
                                                        <td  class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"colspan="12">
                                                            <?php echo e(number_format($totalDriverUsd, 2)); ?>

                                                            <input name="driver_collect_usd" value="<?php echo e($totalDriverUsd); ?>" type="hidden"/>
                                                        </td>
                                                    </tr>
                                                    <tr class="font-bold bg-slate-100 dark:bg-navy-700">
                                                        <td  class="text-right p-2" colspan="7" class="text-right">Total COD KHR: </td>
                                                        <td  class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border  border-b-slate-200 dark:border-b-navy-500"colspan="12">
                                                            <?php echo e(number_format($totalDriverKhr, 2)); ?>

                                                             <input name="driver_collect_khr" value="<?php echo e($totalDriverKhr); ?>" type="hidden"/>
                                                        </td>
                                                    </tr>

                                                </tfoot>
                                            </table>

                                            </div>
                                        </div>
                                    </div>
                                 </div>

                               <div
                                    class="grid grid-cols-1 gap-6"
                                    x-data="paymentForm(<?php echo e(isset($existingPayments) ? json_encode($existingPayments) : '[]'); ?>, <?php echo e($remainingDriverUsd ?? 0); ?>, <?php echo e($remainingDriverKhr ?? 0); ?>)"
                                >
                                    <input type="hidden" name="delivery_by" value="<?php echo e($deliveryBy->id); ?>">

                                    <!-- Cards + Payment Table -->
                                    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

                                        <!-- Summary Cards -->
                                        <div class="grid grid-cols-1 sm:grid-cols-3 lg:grid-cols-3 gap-4">
                                            <!-- Assigned -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100"><?php echo e($statusCounts['assigned'] ?? $summary->assigned ?? 0); ?></p>
                                                    <i class="fas fa-truck text-primary dark:text-accent text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Assigned</p>
                                            </div>

                                            <!-- Success -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100"><?php echo e($statusCounts['completed'] ?? $summary->completed ?? 0); ?></p>
                                                    <i class="fas fa-check-circle text-green-500 text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Success</p>
                                            </div>

                                            <!-- Canceled -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100"><?php echo e($statusCounts['canceled'] ?? $summary->canceled ?? 0); ?></p>
                                                    <i class="fas fa-times-circle text-red-500 text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Canceled</p>
                                            </div>
                                        </div>

                                        <!-- Payment Table -->
                                        <div class="lg:col-span-2 w-full overflow-x-auto">
                                            <table class="min-w-full text-left border border-slate-300 dark:border-navy-500">
                                                <thead class="bg-slate-100 dark:bg-navy-600">
                                                    <tr>
                                                        <th class="p-3 whitespace-nowrap">Amount</th>
                                                        <th class="p-3 whitespace-nowrap">Currency</th>
                                                        <th class="p-3 whitespace-nowrap">Payment Method</th>
                                                    </tr>
                                                </thead>

                                                <tbody>
                                                    <template x-for="(payment, index) in payments" :key="index">
                                                        <tr class="border-t border-slate-200 dark:border-navy-500">
                                                            <!-- Amount -->
                                                            <td class="p-2">
                                                                <input
                                                                    type="number"
                                                                    step="0.01"
                                                                    :name="'payments['+index+'][amount]'"
                                                                    x-model="payment.amount"
                                                                    class="form-input w-full rounded border border-slate-300 px-3 py-2"
                                                                    placeholder="Amount"
                                                                >
                                                            </td>

                                                            <!-- Currency -->
                                                            <td class="p-2">
                                                                <select
                                                                    :name="'payments['+index+'][currency]'"
                                                                    x-model="payment.currency"
                                                                    class="form-select w-full rounded border border-slate-300 px-3 py-2"
                                                                >
                                                                    <option value="usd">USD</option>
                                                                    <option value="khr">KHR</option>
                                                                </select>
                                                            </td>

                                                            <!-- Payment Method -->
                                                            <td class="p-2">
                                                                <select
                                                                    :name="'payments['+index+'][payment_method]'"
                                                                    x-model="payment.payment_method"
                                                                    class="form-select w-full rounded border border-slate-300 px-3 py-2"
                                                                >
                                                                    <option value="cash">Cash</option>
                                                                    <option value="transfer">Transfer</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </template>
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>



                                <!-- Form Buttons -->
                                <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                                    <a href="<?php echo e(route('driver-collect-payment.index')); ?>"
                                        class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                                        Cancel
                                    </a>
                                    <button
                                        type="submit"
                                        class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2 flex items-center justify-center gap-2 disabled:opacity-70"
                                        :disabled="loading"
                                    >
                                        <!-- Spinner -->
                                        <svg
                                            x-show="loading"
                                            class="w-4 h-4 animate-spin text-white"
                                            xmlns="http://www.w3.org/2000/svg"
                                            fill="none"
                                            viewBox="0 0 24 24"
                                        >
                                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                            <path class="opacity-75" fill="currentColor"
                                                d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                                            </path>
                                        </svg>

                                        <!-- Text -->
                                        <span x-show="!loading">
                                            <?php echo e(isset($summary) ? 'Update Collect Payment' : 'Confirm Collect Payment'); ?>

                                        </span>
                                        <span x-show="loading">
                                            Processing...
                                        </span>
                                    </button>

                                </div>
                            </form>
                           
                        </div>
                    </div>


                </div>
            </div>
        </div>

             <!-- Payment Modal -->
    <?php echo $__env->make('pages.driver-collect-payment.payment-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    </main>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>


<?php echo $__env->yieldPushContent('scripts'); ?>
<script>

    document.addEventListener('DOMContentLoaded', () => {
        document.querySelectorAll('.adjust-payment').forEach(button => {
            button.addEventListener('click', () => {
                const data = button.getAttribute('data-payment');

                try {
                    const parsed = JSON.parse(data);
                    window.dispatchEvent(new CustomEvent('open-status-modal', { detail: parsed }));
                } catch (e) {
                    alert('Failed to parse payment data');
                    console.error('Invalid JSON in data-payment:', data);
                }
            });
        });
    });





    function paymentForm(existingPayments = [], totalUsd = 0, totalKhr = 0) {
        return {
            payments: existingPayments.length
                ? existingPayments
                : [
                    { amount: totalUsd, currency: 'usd', payment_method: 'cash' },
                    { amount: totalKhr, currency: 'khr', payment_method: 'cash' }
                ],
            addRow() {
                this.payments.push({ amount: '', currency: 'usd', payment_method: 'cash' });
            },
            removeRow(index) {
                this.payments.splice(index, 1);
            }
        }
    }
</script>
<?php /**PATH C:\laragon\www\lineone-laravel\resources\views/pages/driver-collect-payment/view-collect-payment.blade.php ENDPATH**/ ?>