<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php echo e($customer->customer_name); ?> Invoice</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        .section {
            margin-bottom: 20px;
            text-align: center;
        }

        .summary-box {
            margin-top: 10px;
            margin-bottom: 20px;
            border:1px solid #ccc;
            padding: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
        }

        table, th, td {
            border: 1px solid #999;
        }

        th, td {
            padding: 5px;
            text-align: center;
        }

        tfoot td {
            font-weight: bold;
        }

        .text-right {
            text-align: right;
        }

        .bold {
            font-weight: bold;
        }
            .invoice-info {
                text-align: left;
                vertical-align: top;
                border: none !important;
                font-size: 12px;
            }

            .qr-box {
                text-align: right;
                vertical-align: top;
                border: none !important;
            }

            .qr-item {
                display: inline-block;
                margin-left: 15px;
                text-align: center;
            }


    </style>
</head>
<body>

<div class="section">
    <h2><?php echo e($customer->customer_name); ?> Invoice</h2>
</div>

<div>
    <table>
    <tr>
        <td colspan="7" class="invoice-info">
            <strong>Invoice Number:</strong> <?php echo e($invoiceNumber); ?><br>
            <strong>Branch:</strong> <?php echo e($branch->name); ?><br>
            <strong>Date:</strong> <?php echo e($summary->created_at->format('d M Y')); ?><br>
            <strong>Exchange Rate:</strong> <?php echo e(number_format($exchangeRate, 2)); ?><br>
            <strong>Total Payment:</strong><br>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $existingPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e(number_format($payment['amount'], 2)); ?> <?php echo e(strtoupper($payment['currency'])); ?> <br>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </td>

        <td colspan="5" class="qr-box">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($customer->banks[0])): ?>
                <div class="qr-item">
                    <img src="<?php echo e(url('storage/' . $customer->banks[0]->qr_code)); ?>" width="80"><br>
                    <?php echo e($customer->banks[0]->bank_account_number ?? '-'); ?> | 
                    <?php echo e($customer->banks[0]->bank_account_name ?? '-'); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($customer->banks[1])): ?>
                <div class="qr-item">
                    <img src="<?php echo e(public_path('storage/' . $customer->banks[1]->qr_code)); ?>" width="80"><br>
                    <?php echo e($customer->banks[1]->bank_account_number ?? '-'); ?> | 
                    <?php echo e($customer->banks[1]->bank_account_name ?? '-'); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </td>
    </tr>
</table>

</div>


<h3>Delivery Summary</h3>
<table>
    <thead>
        <tr>
            <th rowspan="2">No</th>
            <th rowspan="2">Address</th>
            <th rowspan="2">Phone</th>
            <th rowspan="2">Entry</th>
            <th rowspan="2">Completed</th>
            <th rowspan="2">Total (USD)</th>
            <th rowspan="2">Total (KHR)</th>
            <th colspan="2">COD</th>
            <th colspan="2">Shop</th>
            <th rowspan="2">Other Fee</th>
            <th rowspan="2">Delivery Fee</th>
            <th rowspan="2">Status</th>
            <th rowspan="2">Note</th>
        </tr>
        <tr>
            <th>USD</th>
            <th>KHR</th>
            <th>USD</th>
            <th>KHR</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $totalDriverUsd = $totalDriverKhr = $totalShopUsd = $totalShopKhr = 0;
            $totalDeliveryFee = $totalAmountUsd = $totalAmountKhr = 0;
            $totalPaidAnyExtraFee = 0;
        ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $driverUsd = $delivery->payments->where('payment_to', 'driver')->where('currency', 'usd')->sum('amount');
                $driverKhr = $delivery->payments->where('payment_to', 'driver')->where('currency', 'khr')->sum('amount');
                $companyUsd = $delivery->payments->where('payment_to', 'company')->where('currency', 'usd')->sum('amount');
                $companyKhr = $delivery->payments->where('payment_to', 'company')->where('currency', 'khr')->sum('amount');
                $shopUsd = $delivery->payments->where('payment_to', 'shop')->where('currency', 'usd')->sum('amount');
                $shopKhr = $delivery->payments->where('payment_to', 'shop')->where('currency', 'khr')->sum('amount');
                $extraFeeUsd = ($delivery->who_pay_fee === 'Driver' || $delivery->who_pay_fee === 'Company') ? ($delivery->any_extra_fee ?? 0) : 0;
                $deliveryFeeUsd = $delivery->delivery_price ?? 0;

                $totalDriverUsd += $driverUsd + $companyUsd;
                $totalDriverKhr += $driverKhr + $companyKhr;
                $totalShopUsd += $shopUsd;
                $totalShopKhr += $shopKhr;
                $totalDeliveryFee += $deliveryFeeUsd;
                $totalAmountUsd += $delivery->amount_usd ?? 0;
                $totalAmountKhr += $delivery->amount_khr ?? 0;
                $totalPaidAnyExtraFee += $extraFeeUsd;
            ?>

            <tr>
                <td><?php echo e($index + 1); ?></td>
                <td><?php echo e($delivery->receiver_address ?? '-'); ?></td>
                <td><?php echo e($delivery->receiver_phone ?? '-'); ?></td>
                <td><?php echo e(\Carbon\Carbon::parse($delivery->pickup_at)->format('d-m-Y')); ?></td>
                <td><?php echo e($delivery->completed_at ? \Carbon\Carbon::parse($delivery->completed_at)->format('d-m-Y') : '-'); ?></td>
                <td><?php echo e(number_format($delivery->amount_usd, 2)); ?></td>
                <td><?php echo e(number_format($delivery->amount_khr, 0)); ?></td>
                <td><?php echo e(number_format($driverUsd + $companyUsd, 2)); ?></td>
                <td><?php echo e(number_format($driverKhr + $companyKhr, 0)); ?></td>
                <td><?php echo e(number_format($shopUsd, 2)); ?></td>
                <td><?php echo e(number_format($shopKhr, 0)); ?></td>
                <td><?php echo e(number_format($extraFeeUsd, 2)); ?></td>
                <td><?php echo e(number_format($deliveryFeeUsd, 2)); ?></td>
                <td><?php echo e(ucfirst($delivery->status)); ?></td>
                <td><?php echo e($delivery->note); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="5" class="text-right">Total Collected:</td>
            <td><?php echo e(number_format($totalAmountUsd, 2)); ?></td>
            <td><?php echo e(number_format($totalAmountKhr, 0)); ?></td>
            <td><?php echo e(number_format($totalDriverUsd, 2)); ?></td>
            <td><?php echo e(number_format($totalDriverKhr, 0)); ?></td>
            <td><?php echo e(number_format($totalShopUsd, 2)); ?></td>
            <td><?php echo e(number_format($totalShopKhr, 0)); ?></td>
            <td><?php echo e(number_format($totalPaidAnyExtraFee, 2)); ?></td>
            <td><?php echo e(number_format($totalDeliveryFee, 2)); ?></td>
            <td colspan="2"></td>
        </tr>
     
    </tfoot>
</table>


<div class="section text-right bold">
    Printed on: <?php echo e(now()->format('d M Y H:i')); ?>

</div>

</body>
</html>
<?php /**PATH C:\laragon\www\lineone-laravel\resources\views/pages/shop-collect-payment/download.blade.php ENDPATH**/ ?>