<div class="main-sidebar">
    <div
        class="flex h-full w-full flex-col items-center border-r border-slate-150 bg-white dark:border-navy-700 dark:bg-navy-800">
        <!-- Application Logo -->
        <div class="flex pt-4">
            <a href="/">
                
                     <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($currentBranch && $currentBranch->logo): ?>

                        <img class="size-11 transition-transform duration-500 ease-in-out hover:rotate-[360deg]"
                            src="<?php echo e(asset('storage/'. $currentBranch->logo)); ?>" alt="logo" style="max-width: 100%;height: auto;"/>
                    <?php else: ?>
                        <img class="size-11 transition-transform duration-500 ease-in-out hover:rotate-[360deg]"
                            src="<?php echo e(asset('images/app-logo.svg')); ?>" alt="Default Logo" />
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </a>
        </div>
        <?php
            $currentRoute = Route::currentRouteName();
            $activeRoutes = ['booking.index', 'booking-order.index','transit.index','in-transit.index','shipment.index'];
        ?>
        <!-- Main Sections Links -->
        <div class="is-scrollbar-hidden flex grow flex-col space-y-4 overflow-y-auto pt-6">
            <!-- Dashobards -->
            
            <a href="<?php echo e(route('dashboards.index')); ?>"
                class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 
                <?php echo e($routePrefix === 'dashboards.index' ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                x-tooltip.placement.right="'Dashboards'">
                <svg class="size-7" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                    <path fill="currentColor" fill-opacity=".3"
                        d="M5 14.059c0-1.01 0-1.514.222-1.945.221-.43.632-.724 1.453-1.31l4.163-2.974c.56-.4.842-.601 1.162-.601.32 0 .601.2 1.162.601l4.163 2.974c.821.586 1.232.88 1.453 1.31.222.43.222.935.222 1.945V19c0 .943 0 1.414-.293 1.707C18.414 21 17.943 21 17 21H7c-.943 0-1.414 0-1.707-.293C5 20.414 5 19.943 5 19v-4.94Z" />
                    <path fill="currentColor"
                        d="M3 12.387c0 .267 0 .4.084.441.084.041.19-.04.4-.204l7.288-5.669c.59-.459.885-.688 1.228-.688.343 0 .638.23 1.228.688l7.288 5.669c.21.163.316.245.4.204.084-.04.084-.174.084-.441v-.409c0-.48 0-.72-.102-.928-.101-.208-.291-.355-.67-.65l-7-5.445c-.59-.459-.885-.688-1.228-.688-.343 0-.638.23-1.228.688l-7 5.445c-.379.295-.569.442-.67.65-.102.208-.102.448-.102.928v.409Z" />
                    <path fill="currentColor" d="M11.5 15.5h1A1.5 1.5 0 0 1 14 17v3.5h-4V17a1.5 1.5 0 0 1 1.5-1.5Z" />
                    <path fill="currentColor"
                        d="M17.5 5h-1a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5Z" />
                </svg>
            </a>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.view')): ?>
                <a href="<?php echo e(route('customer.index')); ?>"
                      class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200
                    <?php echo e(Str::startsWith($currentRoute, 'customer.') ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                    x-tooltip.placement.right="'Customer'">
                    <!-- Customer Icon -->
                    <svg class="size-7" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12 12C14.2091 12 16 10.2091 16 8C16 5.79086 14.2091 4 12 4C9.79086 4 8 5.79086 8 8C8 10.2091 9.79086 12 12 12Z" fill="currentColor"/>
                        <path fill-opacity="0.3" d="M4 20C4 16.6863 7.13401 14 11 14H13C16.866 14 20 16.6863 20 20V21H4V20Z" fill="currentColor"/>
                    </svg>
                </a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.view')): ?>
                <a href="<?php echo e(route('booking.index')); ?>"
                   class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200
                    <?php echo e(in_array($currentRoute, $activeRoutes) ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                    x-tooltip.placement.right="'Booking'">
                    <!-- booking Icon -->
                    <svg class="size-7" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M7 2V5M17 2V5M3 9H21M5 5H19C20.1046 5 21 5.89543 21 7V19C21 20.1046 20.1046 21 19 21H5C3.89543 21 3 20.1046 3 19V7C3 5.89543 3.89543 5 5 5Z"
                            stroke="currentColor"
                            stroke-width="1.5"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        />
                        <path
                            d="M8 13H8.01M12 13H12.01M16 13H16.01M8 17H8.01M12 17H12.01"
                            stroke="currentColor"
                            stroke-width="2"
                            stroke-linecap="round"
                        />
                    </svg>

                </a>
            <?php endif; ?>


            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delivery.create')): ?>
            <a href="<?php echo e(route('data-inquiry.index')); ?>"
                class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200
                    <?php echo e(Str::startsWith($currentRoute, 'data-inquiry.') ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                    x-tooltip.placement.right="'Data Entry'">
                <svg class="size-7" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M13.3111 14.75H5.03356C3.36523 14.75 2.30189 12.9625 3.10856 11.4958L5.24439 7.60911L7.24273 3.96995C8.07689 2.45745 10.2586 2.45745 11.0927 3.96995L13.1002 7.60911L14.0627 9.35995L15.2361 11.4958C16.0427 12.9625 14.9794 14.75 13.3111 14.75Z"
                        fill="currentColor" />
                    <path fill-opacity="0.3"
                        d="M21.1667 15.2083C21.1667 18.4992 18.4992 21.1667 15.2083 21.1667C11.9175 21.1667 9.25 18.4992 9.25 15.2083C9.25 15.0525 9.25917 14.9058 9.26833 14.75H13.3108C14.9792 14.75 16.0425 12.9625 15.2358 11.4958L14.0625 9.36C14.4292 9.28666 14.8142 9.25 15.2083 9.25C18.4992 9.25 21.1667 11.9175 21.1667 15.2083Z"
                        fill="currentColor" />
                </svg>
            </a>
            <?php endif; ?>


            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delivery.view')): ?>
            <a href="<?php echo e(route('delivery.index')); ?>"
                class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 
                <?php echo e($routePrefix === 'delivery.index' ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                x-tooltip.placement.right="'Delivery'">
                <!-- Delivery Icon -->
                <svg class="size-7" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M3 7H16V17H3V7Z" fill="currentColor"/>
                    <path fill-opacity="0.3" d="M16 7H20L21 9V17H16V7Z" fill="currentColor"/>
                    <circle cx="7.5" cy="17.5" r="1.5" fill="currentColor"/>
                    <circle cx="17.5" cy="17.5" r="1.5" fill="currentColor"/>
                </svg>
            </a>
            <?php endif; ?>

         

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('driver-payment.view')): ?>
                <a href="<?php echo e(route('driver-collect-payment.index')); ?>"
                    class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 
                    <?php echo e($routePrefix === 'driver-collect-payment.index' || $routePrefix === 'driver-payment.index' ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                    x-tooltip.placement.right="'Driver Collect Payment'">
                    <svg class="size-7" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <!-- Shop icon -->
                        <rect x="2" y="5" width="8" height="6" rx="1" ry="1" stroke-linecap="round"
                            stroke-linejoin="round"></rect>
                        <path d="M2 5l1-2h6l1 2" stroke-linecap="round" stroke-linejoin="round"></path>

                        <!-- Driver (person in car) -->
                        <circle cx="17" cy="8" r="2" stroke-linecap="round" stroke-linejoin="round"></circle>
                        <rect x="14" y="10" width="6" height="4" rx="1" ry="1" stroke-linecap="round"
                            stroke-linejoin="round"></rect>
                        <rect x="13" y="14" width="8" height="3" rx="1" ry="1" stroke-linecap="round"
                            stroke-linejoin="round"></rect>

                        <!-- Money exchange -->
                        <rect x="9" y="11" width="4" height="2.5" rx="0.5" ry="0.5" stroke-linecap="round"
                            stroke-linejoin="round"></rect>
                        <text x="11" y="13" font-size="2.5" text-anchor="middle" fill="currentColor">$</text>
                    </svg>
                </a>
            <?php endif; ?>


            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-payment.view')): ?>
            <a href="<?php echo e(route('all-shop-collect-payment.index')); ?>"
                class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 
                <?php echo e($routePrefix === 'all-shop-collect-payment.index' ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                x-tooltip.placement.right="'Customer Collect Payment'">
                <svg class="size-7" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                    <rect width="18" height="12" x="3" y="6" rx="2" ry="2" stroke-linecap="round" stroke-linejoin="round"></rect>
                    <circle cx="12" cy="12" r="2" stroke-linecap="round" stroke-linejoin="round"></circle>
                </svg>
            </a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-payment.view')): ?>
            <!-- Report -->
            <a href="<?php echo e(route('reports.index')); ?>"
                class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 <?php echo e($routePrefix === 'report' ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                x-tooltip.placement.right="'Reports'">
                <svg class="size-7" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                    <path d="M9 17v-2a2 2 0 0 1 2-2h6" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M13 7h-1a2 2 0 0 0-2 2v1" stroke-linecap="round" stroke-linejoin="round"/>
                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('branch.view')): ?> 
            <!-- Configurations -->
            <a href="<?php echo e(route('branch.index')); ?>"
                class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 <?php echo e($routePrefix === 'configurations' ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                x-tooltip.placement.right="'Configurations'">
                <!-- Configurations Icon -->
                <svg class="size-7" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M4 6H20V8H4V6ZM4 10H20V12H4V10ZM4 14H20V16H4V14ZM4 18H20V20H4V18Z" fill="currentColor" />
                </svg>
            </a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-payment.view')): ?>
            <!-- Settings -->
            <a href="<?php echo e(route('setting.index')); ?>"
                class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 <?php echo e($routePrefix === 'settings' ? 'text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:bg-navy-600 bg-primary/10 dark:text-accent-light dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90' : 'hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25'); ?>"
                x-tooltip.placement.right="'Settings'">
                <!-- Settings Icon -->
                <svg class="size-7" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 15.5C13.933 15.5 15.5 13.933 15.5 12C15.5 10.067 13.933 8.5 12 8.5C10.067 8.5 8.5 10.067 8.5 12C8.5 13.933 10.067 15.5 12 15.5Z" fill="currentColor"/>
                    <path fill-opacity="0.3" d="M19.43 12.98C19.47 12.66 19.5 12.33 19.5 12C19.5 11.67 19.47 11.34 19.43 11.02L21.54 9.37C21.71 9.24 21.76 9 21.66 8.79L19.66 4.79C19.56 4.58 19.33 4.5 19.12 4.57L16.56 5.45C16.04 5.16 15.5 4.91 14.92 4.73L14.5 2H9.5L9.08 4.73C8.5 4.91 7.96 5.16 7.44 5.45L4.88 4.57C4.67 4.5 4.44 4.58 4.34 4.79L2.34 8.79C2.24 9 2.29 9.24 2.46 9.37L4.57 11.02C4.53 11.34 4.5 11.67 4.5 12C4.5 12.33 4.53 12.66 4.57 12.98L2.46 14.63C2.29 14.76 2.24 15 2.34 15.21L4.34 19.21C4.44 19.42 4.67 19.5 4.88 19.43L7.44 18.55C7.96 18.84 8.5 19.09 9.08 19.27L9.5 22H14.5L14.92 19.27C15.5 19.09 16.04 18.84 16.56 18.55L19.12 19.43C19.33 19.5 19.56 19.42 19.66 19.21L21.66 15.21C21.76 15 21.71 14.76 21.54 14.63L19.43 12.98Z" fill="currentColor"/>
                </svg>
            </a>
            <?php endif; ?>
            

        </div>

        <!-- Bottom Links -->
        <div class="flex flex-col items-center space-y-3 py-3">
            <?php /*
            <!-- Settings -->
            <a href="{{ route('forms/layout-v5') }}"
                class="flex size-11 items-center justify-center rounded-lg outline-hidden transition-colors duration-200 hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25">
                <svg class="size-7" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-opacity="0.3" fill="currentColor"
                        d="M2 12.947v-1.771c0-1.047.85-1.913 1.899-1.913 1.81 0 2.549-1.288 1.64-2.868a1.919 1.919 0 0 1 .699-2.607l1.729-.996c.79-.474 1.81-.192 2.279.603l.11.192c.9 1.58 2.379 1.58 3.288 0l.11-.192c.47-.795 1.49-1.077 2.279-.603l1.73.996a1.92 1.92 0 0 1 .699 2.607c-.91 1.58-.17 2.868 1.639 2.868 1.04 0 1.899.856 1.899 1.912v1.772c0 1.047-.85 1.912-1.9 1.912-1.808 0-2.548 1.288-1.638 2.869.52.915.21 2.083-.7 2.606l-1.729.997c-.79.473-1.81.191-2.279-.604l-.11-.191c-.9-1.58-2.379-1.58-3.288 0l-.11.19c-.47.796-1.49 1.078-2.279.605l-1.73-.997a1.919 1.919 0 0 1-.699-2.606c.91-1.58.17-2.869-1.639-2.869A1.911 1.911 0 0 1 2 12.947Z" />
                    <path fill="currentColor"
                        d="M11.995 15.332c1.794 0 3.248-1.464 3.248-3.27 0-1.807-1.454-3.272-3.248-3.272-1.794 0-3.248 1.465-3.248 3.271 0 1.807 1.454 3.271 3.248 3.271Z" />
                </svg>
            </a>
            */?>

            <!-- Profile -->
            <div x-data="usePopper({ placement: 'right-end', offset: 12 })" @click.outside="if(isShowPopper) isShowPopper = false" class="flex">
                <button @click="isShowPopper = !isShowPopper" x-ref="popperRef" class="avatar size-12 cursor-pointer">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($currentBranch && $currentBranch->logo): ?>
                        <img class="rounded-full"
                            src="<?php echo e(asset('storage/' . $currentBranch->logo)); ?>" alt="Branch Logo" />
                    <?php else: ?>
                        <img class="rounded-full"
                            src="<?php echo e(asset('images/app-logo.svg')); ?>" alt="Default Logo" />
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <span
                        class="absolute right-0 size-3.5 rounded-full border-2 border-white bg-success dark:border-navy-700"></span>
                </button>
                <div :class="isShowPopper && 'show'" class="popper-root fixed" x-ref="popperRoot">
                    <div
                        class="popper-box w-64 rounded-lg border border-slate-150 bg-white shadow-soft dark:border-navy-600 dark:bg-navy-700">
                        <div class="flex items-center space-x-4 rounded-t-lg bg-slate-100 py-5 px-4 dark:bg-navy-800">
                            
                            <div>
                                <div class="text-base font-medium text-slate-700 hover:text-primary focus:text-primary dark:text-navy-100 dark:hover:text-accent-light dark:focus:text-accent-light">
                                    Current Branches    
                                </div>
                                <p class="text-xs text-slate-400 dark:text-navy-300">
                                    <?php echo e($currentBranch->phone); ?>

                                </p>
                            </div>
                        </div>
                        <div class="flex flex-col pt-2 pb-5">

                             <form id="branchSwitcherForm" action="<?php echo e(route('switch-branch')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                                <div class="group flex items-center space-x-3 py-2 px-4 tracking-wide outline-hidden transition-all hover:bg-slate-100 focus:bg-slate-100 dark:hover:bg-navy-600 dark:focus:bg-navy-600">
                                
                                <select name="branch_id" onchange="document.getElementById('branchSwitcherForm').submit()" class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary disabled:pointer-events-none disabled:select-none disabled:border-none disabled:bg-zinc-100 dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent dark:disabled:bg-navy-600">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = auth()->user()->branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($branch->id); ?>" <?php echo e(session('current_branch_id') == $branch->id ? 'selected' : ''); ?>>
                                            <?php echo e($branch->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                                </div>
                            </form>
                           
                            
                            
                            <div class="mt-3 px-4">
                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit"
                                        class="btn h-9 w-full space-x-2 bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                                        </svg>
                                        <span>Logout</span>
                                    </button>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\lineone-laravel\resources\views/components/app-partials/sidebar.blade.php ENDPATH**/ ?>