<x-app-layout title="EOD Report" is-header-blur="false" is-sidebar-open="true">

<main class="main-content w-full px-[var(--margin-x)] pb-8 print:px-4">
    
    <!-- Header -->
    <div class="flex items-center justify-between py-4">
        <h2 class="text-xl font-semibold text-slate-800">
            End of Day (EOD) Summary
        </h2>

        <button onclick="window.print()"
            class="btn btn-sm bg-primary text-white print:hidden">
            Print
        </button>
    </div>

    <div class="card p-4 space-y-6">

     <form method="GET" action="{{ route('summaryIncomeFromDelivery.index') }}" class="flex items-end gap-3">
        <div x-data="{ dateValue: '{{ request('date') }}' }" class="w-72">
            <label class="block">
                <span class="text-sm font-medium text-slate-700">Filter Date</span>

                <div class="relative mt-1.5">
                    <!-- Calendar Icon -->
                    <span
                        class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"
                    >
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5"
                            fill="none" viewBox="0 0 24 24"
                            stroke="currentColor" stroke-width="1.5">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </span>

                    <!-- Date Input -->
                    <input
                        name="date"
                        x-model="dateValue"
                        x-init="
                            flatpickr($el, {
                                mode: 'range',
                                dateFormat: 'Y-m-d',
                                defaultDate: dateValue ? dateValue.split(' to ') : null,
                                onChange(_, dateStr) {
                                    dateValue = dateStr;
                                }
                            });
                        "
                        type="text"
                        placeholder="Select date range"
                        class="form-input w-full rounded-lg border border-slate-300
                            bg-transparent px-3 py-2 pl-10 pr-3
                            focus:border-primary focus:ring-primary"
                    />
                </div>
            </label>
        </div>

        <!-- Apply Button -->
        <button
            type="submit"
            class="btn h-[38px] bg-primary text-white px-5 rounded-lg
                hover:bg-primary-focus transition"
        >
            Apply
        </button>
    </form>



        <!-- SECTION 1: DELIVERY SUMMARY -->
        <table class="eod-table">
            <thead>
                <tr>
                    <th colspan="8" class="eod-title">
                        1. Daily Delivery Summary
                    </th>
                </tr>
                <tr>
                    <th rowspan="2">Total Package</th>
                    <th rowspan="2">In Stock</th>
                    <th rowspan="2">In Progress</th>
                    <th rowspan="2">Canceled</th>
                    <th rowspan="2">Completed</th>
                    <th colspan="2">Amount</th>
                </tr>
                <tr>
                    <th>USD</th>
                    <th>KHR</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $grandTotal['total_package'] ?? 0 }}</td>
                    <td>{{ $grandTotal['in_stock'] ?? 0 }}</td>
                    <td>{{ $grandTotal['assigned'] ?? 0 }}</td>
                    <td>{{ $grandTotal['canceled'] ?? 0 }}</td>
                    <td>{{ $grandTotal['completed'] ?? 0 }}</td>
                    <td>{{ number_format($grandTotal['total_usd'] ?? 0, 2) }}</td>
                    <td>{{ number_format($grandTotal['total_khr'] ?? 0) }}</td>
                </tr>
            </tbody>
        </table>

        <!-- SECTION 2: DRIVER SUMMARY -->
        <table class="eod-table">
            <thead>
                <tr>
                    <th colspan="8" class="eod-title">
                        2. Daily Driver Summary
                    </th>
                </tr>
                <tr>
                    <th colspan="4">Total Drivers</th>
                    <th colspan="2"> Amount Collected</th>
                    <th colspan="2">Paid to company</th>
                </tr>
                <tr>
                    <th colspan="4"></th>
                    <th>USD</th>
                    <th>KHR</th>
                    <th>USD</th>
                    <th>KHR</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td colspan="4">{{ $dailySummaryDriver->total_driver ?? 0 }}</td>
                    <td>{{ $dailySummaryDriver->total_amount_usd ?? 0 }}</td>
                    <td>{{ $dailySummaryDriver->total_amount_khr ?? 0 }}</td>
                    <td>{{ $dailySummaryDriver->driver_collect_usd ?? 0 }}</td>
                    <td>{{ $dailySummaryDriver->driver_collect_khr ?? 0 }}</td>
                </tr>
            </tbody>
        </table>

        <!-- SECTION 3: SHOP SUMMARY -->
        <table class="eod-table">
            <thead>
                <tr>
                    <th colspan="8" class="eod-title">
                        3. Daily Shop Summary
                    </th>
                </tr>
                <tr>
                    <th colspan="2">Total Shops</th>
                    <th colspan="2">Service Fee</th>
                    <th colspan="2">Collected Amount</th>
                    <th colspan="2">Paid To Shop</th>
                </tr>
                <tr>
                    <th colspan="2"></th>
                    <th colspan="2"></th>
                    <th>USD</th>
                    <th>KHR</th>
                    <th>USD</th>
                    <th>KHR</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td colspan="2">{{ $grandTotal['total_shop'] ?? 0 }}</td>
                    <td colspan="2">{{ number_format($grandTotal['service_fee'] ?? 0, 2) }}</td>
                    <td>{{ number_format($grandTotal['usd'] ?? 0, 2) }}</td>
                    <td>{{ number_format($grandTotal['khr']?? 0) }}</td>
                    <td>{{ number_format($grandTotal['paid_usd'] ?? 0, 2) }}</td>
                    <td>{{ number_format($grandTotal['paid_khr'] ?? 0) }}</td>
                </tr>
            </tbody>
        </table>

    </div>
<style>
    .eod-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
}

.eod-table th,
.eod-table td {
    border: 1px solid #cbd5e1;
    padding: 6px;
    text-align: center;
}

.eod-table thead {
    background-color: #f1f5f9;
}

.eod-title {
    text-align: left !important;
    font-weight: 600;
    background-color: #e2e8f0;
}

</style>
</main>

</x-app-layout>
