<x-app-layout title="Collect Payment With shop" is-header-blur="false" is-sidebar-open="false" header-sticky="false" has-min-sidebar="false">
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">Collect Payment</h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">List</a>
                    <svg x-ignore xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>shop</li>
            </ul>

            <!-- Back Button -->
            <div class="ml-auto">
  
                <a href="{{ route('shop-collect-payment.index') }}" class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">Back</a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
            <div>
                <div class="card p-2 mt-3">
                    
                @if ($errors->any())
                        <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>- {{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                                                

                    <div class="card">
                        <div class="border border-slate-200 p-2 dark:border-navy-500">
                            <form method="POST"
                                action="{{ isset($summary) ? route('shop-collect-payment.update', $summary->id) : route('shop-collect-payment.store') }}"
                                enctype="multipart/form-data" class="space-y-4" id="deliveryForm"
                                 x-data="{ loading: false }"
                                @submit="loading = true">
                                @csrf
                                @if (isset($summary))
                                    @method('PUT')
                                @endif
                                  <div class="w-full max-w-full px-0 mx-0">
                                     <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6 w-full">
                                        <div class="card p-2">
                                            <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">

                                                <div class="mb-6 p-4 border border-slate-300 dark:border-navy-600 rounded bg-slate-50 dark:bg-navy-700">
                                                    <div class="flex flex-col items-center justify-center text-center space-y-1  border-b border-slate-300 font-bold mb-4">
                                                        <img src="{{ asset('storage/'. $currentBranch->logo) }}" alt="Logo" class="w-30">
                                                        
                                                        <p><span class="font-semibold">Branch:</span> {{ $branch->name }} | {{ $branch->phone }}</p>
                                                        <p><span class="font-semibold">Address:</span> {{ $branch->address }}</p>
                                                        
                                                        <h2 class="text-xl text-slate-800 dark:text-navy-100">
                                                            Shop Payment Invoice
                                                        </h2>
                                                    </div>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div class="text-slate-700 dark:text-navy-100">
                                                            <p><span class="font-semibold">Shop Name:</span> {{ $customer->customer_name }}</p>
                                                            <p><span class="font-semibold">Exchange Rate:</span> 1 USD = {{ number_format($exchangeRate, 0) }} KHR</p>
                                                        </div>
                                                        <div class="text-right text-slate-700 dark:text-navy-100">
                                                            <p><span class="font-semibold">Invoice No:</span> {{ $invoiceNumber }}</p>
                                                            <p><span class="font-semibold">Print Date:</span> {{ now()->format('d-m-Y H:i:s') }}</p>
                                                        </div>
                                                    </div>
                                                </div>


                                            @php
                                                // Initialize Totals
                                                $totalDriverUsd = 0;
                                                $totalDriverKhr = 0;
                                                $totalShopUsd = 0;
                                                $totalShopKhr = 0;
                                                $totalCompanyUsd = 0;
                                                $totalCompanyKhr = 0;
                                                $totalDeliveryFee = 0;
                                                $totalAmountUsd = 0;
                                                $totalAmountKhr = 0;
                                                $totalPaidWithShopUsd = 0;
                                                $totalPaidWithShopKhr = 0;
                                                $totalPaidAnyExtraFee = 0;
                                                $totalAnyExtraFee = 0;
                                                $totalAnyExtraFeeDriver = 0;
                                                $totalAnyExtraFeeCompany = 0;
                                            @endphp

                                            <table class="is-hoverable w-full text-left data-table border-collapse border border-slate-300">

                                                <thead>
                                                    <tr>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">N<sup>o</sup></th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Address</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Phone</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Entry</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Completed</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Total (USD)</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Total (KHR)</th>
                                                        <th colspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">COD</th>
                                                        <th colspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Shop</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Other Fee</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Delivery Fee</th>
                                                        <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Status</th>
                                                         <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Action</th>
                                                        <!-- <th rowspan="2" class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">Action</th> -->
                                                    </tr>
                                                    <tr>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">USD</th>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">KHR</th>

                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">USD</th>
                                                        <th class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">KHR</th>

                                                    </tr>
                                                </thead>

                                                <tbody class="gridjs-tbody">
                                                    @foreach($deliveries as $index => $delivery)
                                                      
                                                   <?php 
                                                    // Step 1: Payments to each party
                                                    $driverUsd = $delivery->payments->where('payment_to', 'driver')->where('currency', 'usd')->sum('amount');
                                                    $driverKhr = $delivery->payments->where('payment_to', 'driver')->where('currency', 'khr')->sum('amount');

                                                    $companyUsd = $delivery->payments->where('payment_to', 'company')->where('currency', 'usd')->sum('amount');
                                                    $companyKhr = $delivery->payments->where('payment_to', 'company')->where('currency', 'khr')->sum('amount');

                                                    $shopUsd = $delivery->payments->where('payment_to', 'shop')->where('currency', 'usd')->sum('amount');
                                                    $shopKhr = $delivery->payments->where('payment_to', 'shop')->where('currency', 'khr')->sum('amount');

                                                    // Step 2: Total collected (driver + company)
                                                    $totalCollectedUsd = $driverUsd + $companyUsd;
                                                    $totalCollectedKhr = $driverKhr + $companyKhr;

                                                    // Step 3: Fee deductions
                                                    $extraFee = $delivery->any_extra_fee ?? 0;
                                                    $deliveryFeeUsd = $delivery->delivery_price ?? 0;

                                                    $extraFeeUsd = ($delivery->who_pay_fee === 'Driver' || $delivery->who_pay_fee === 'Company') ? $extraFee : 0;
                                                    $totalDeductUsd = $deliveryFeeUsd + $extraFeeUsd;

                                                    // Step 4: Calculate available USD + fallback to KHR
                                              
                                                
                                                    // Optional: accumulate totals
                                                    $totalDriverUsd += $totalCollectedUsd;
                                                    $totalDriverKhr += $totalCollectedKhr;
                                                    $totalShopUsd += $shopUsd;
                                                    $totalShopKhr += $shopKhr;
                                                    $totalDeliveryFee += $deliveryFeeUsd;
                                                    $totalAmountUsd += $delivery->amount_usd ?? 0;
                                                    $totalAmountKhr += $delivery->amount_khr ?? 0;
                                                    $totalPaidAnyExtraFee += $extraFeeUsd;
                                                ?>


                                                        <tr>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ $index + 1 }}
                                                                 <input type="hidden" name="delivery_ids[]" value="{{ $delivery->id }}">
                                                            </td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ $delivery->receiver_address ?? '-' }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ $delivery->receiver_phone ?? '-' }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ \Carbon\Carbon::parse($delivery->pickup_at)->format('d-m-Y') }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                                                                {{ $delivery->completed_at ? \Carbon\Carbon::parse($delivery->completed_at)->format('d-m-Y') : '-' }}
                                                            </td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($delivery->amount_usd, 2) }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($delivery->amount_khr, 0) }}</td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format(($driverUsd+$companyUsd), 2) }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format(($driverKhr+$companyKhr), 0) }}</td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($shopUsd, 2) }}</td>
                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($shopKhr, 0) }}</td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($extraFeeUsd, 2) }} </td>

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($delivery->delivery_price, 2) }}</td>
                                                          

                                                            <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ ucfirst($delivery->status) }}</td>
                                                     
                                                             <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500 text-center">
                                                            @php
                                                                $paymentData = [
                                                                    'deliveryId' => $delivery->id,
                                                                    'deliveryFee' => $delivery->delivery_price,
                                                                    'customerName' => $delivery->customer->customer_name,
                                                                    'amountUsd' => (float) $delivery->amount_usd,
                                                                    'amountKhr' => (float) $delivery->amount_khr,
                                                                    'note' => $delivery->note,
                                                                    'payments' => $delivery->payments->map(function ($p) {
                                                                        return [
                                                                            'payment_to' => $p->payment_to,
                                                                            'amount' => (float) $p->amount,
                                                                            'currency' => $p->currency,
                                                                            'payment_method' => $p->payment_method,
                                                                        ];
                                                                    })->values()->all(),
                                                                ];
                                                            @endphp

                                                            <div
                                                                class="adjust-payment"
                                                                x-data
                                                                data-payment='@json($paymentData)'
                                                            >
                                                             <span  class="badge cursor-pointer space-x-2.5 rounded-full bg-warning/10 text-warning dark:bg-warning/15">
                                                                Adjust
                                                            </span> 
                                                            </div>

                                                            </td> 
                                                            
                                                        </tr>
                                                    @endforeach
                                                </tbody>

                                                <tfoot class="p-2">
                                                    <tr class="font-bold bg-slate-100 dark:bg-navy-700 p-2">

                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500 text-right" colspan="5">Total:</td>

                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($totalAmountUsd, 2) }}
                                                               <input type="hidden" value="{{$totalAmountUsd}}" name="total_amount_usd"/>

                                                        </td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($totalAmountKhr, 0) }}
                                                            <input type="hidden" value="{{$totalAmountKhr}}" name="total_amount_khr"/>
                                                        </td>

                                                        {{-- Driver Totals --}}
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($totalDriverUsd, 2) }}</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($totalDriverKhr, 0) }}</td>

                                                        {{-- Shop Totals --}}
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($totalShopUsd, 2) }}</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($totalShopKhr, 0) }}</td>

                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($totalPaidAnyExtraFee, 2) }}
                                                            <input type="hidden" value="{{$totalPaidAnyExtraFee}}" name="any_extra_fee"/>
                                                        </td>

                                                        {{-- Delivery Fee and Amounts --}}
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500">{{ number_format($totalDeliveryFee, 2) }}
                                                            <input type="hidden" value="{{$totalDeliveryFee}}" name="service_fee"/>
                                                        </td>

                                                        {{-- Empty Delivery Status --}}
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500"></td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500"></td>
                                                        <!-- <td></td> -->
                                                    </tr>

                                                    <tr class="font-bold bg-slate-100 dark:bg-navy-700 p-2">
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500 text-right" colspan="5">Total Other Fee:</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500" colspan="10">{{ number_format($totalPaidAnyExtraFee, 2) }}</td>
                                                    </tr>
                                                    <tr class="font-bold bg-slate-100 dark:bg-navy-700 p-2">
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500 text-right" colspan="5">Total Delivery Fee:</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500" colspan="10">{{ number_format($totalDeliveryFee, 2) }}</td>
                                                    </tr>
                                                    <tr class="font-bold bg-slate-100 dark:bg-navy-700 p-2">
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500 text-right" colspan="5">Total Amount USD:</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500" colspan="10">{{ number_format($totalDriverUsd, 2) }}</td>
                                                    </tr>
                                                    <tr class="font-bold bg-slate-100 dark:bg-navy-700 p-2">
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500 text-right" colspan="5">Total Amount KHR:</td>
                                                        <td class="whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500" colspan="10">{{ number_format($totalDriverKhr, 2) }}</td>
                                                    </tr>

                                                </tfoot>
                                            </table>

                                            </div>
                                        </div>
                                    </div>
                                 </div>


                                                <?php 

                                                    $remainingUsd = $totalDriverUsd - ($totalDeliveryFee + $totalPaidAnyExtraFee);

                                                    if ($remainingUsd >= 0) {
                                                        $shopReturnUsd = $remainingUsd;
                                                        $shopReturnKhr = $totalDriverKhr;
                                                    } else {
                                                        if($totalDriverKhr === 0){
                                                            $shopReturnUsd = $remainingUsd;
                                                            $shopReturnKhr = $totalDriverKhr;
                                                        }else{
                                                            $usdShortage = abs($remainingUsd);
                                                           $deductKhr = $usdShortage * $exchangeRate;

                                                            $shopReturnUsd = 0;
                                                           $shopReturnKhr = $totalDriverKhr - $deductKhr;
                                                        }
                                                    }

                                                    // Step 5: Final return after subtracting shop-paid amounts
                                                
                                                    $finalReturnUsd = round($shopReturnUsd - $shopUsd, 2);
                                                    $finalReturnKhr = round($shopReturnKhr - $shopKhr, -2); // round to nearest 100

                                                    ?>

                               <div class="grid grid-cols-1 gap-4 sm:grid-cols-1" 
                                    x-data="paymentForm({{ isset($existingPayments) ? json_encode($existingPayments) : '[]' }}, {{ $finalReturnUsd ?? 0 }}, {{ $finalReturnKhr ?? 0 }})">
                              
                                    <h3 class="text-lg font-semibold">Collect Payment With Shop</h3>
                                    <input type="hidden" name="customer_id" value="{{ $customer->id }}">

                                     <!-- Cards + Payment Table -->
                                    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                                         <!-- Summary Cards -->
                                        <div class="grid grid-cols-1 sm:grid-cols-3 lg:grid-cols-3 gap-4">
                                            <!-- Assigned -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100">{{ $statusCounts['assigned'] ?? $summary->assigned ?? 0 }}</p>
                                                    <i class="fas fa-truck text-primary dark:text-accent text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Assigned</p>
                                            </div>

                                            <!-- Success -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100">{{ $statusCounts['completed'] ?? $summary->completed ?? 0}}</p>
                                                    <i class="fas fa-check-circle text-green-500 text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Success</p>
                                            </div>

                                            <!-- Canceled -->
                                            <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                                <div class="flex justify-between items-center">
                                                    <p class="text-2xl font-semibold text-slate-700 dark:text-navy-100">{{ $statusCounts['canceled'] ?? $summary->canceled ?? 0}}</p>
                                                    <i class="fas fa-times-circle text-red-500 text-xl"></i>
                                                </div>
                                                <p class="mt-1 text-sm">Canceled</p>
                                            </div>
                                        </div>
                                        <div class="lg:col-span-2 w-full overflow-x-auto">
                                            <table class="w-full text-left border border-slate-300 dark:border-navy-500">
                                                <thead class="bg-slate-100 dark:bg-navy-600">
                                                    <tr>
                                                        <th class="p-2">Amount + Deduct With Service Fee</th>
                                                        <th class="p-2">Currency</th>
                                                        <!-- <th class="p-2">Payment Method</th>
                                                        <th class="p-2">
                                                            <button type="button" @click="addRow()"
                                                                class="float-end btn rounded-full bg-green-500 text-white hover:bg-green-600">
                                                                Add More
                                                            </button>
                                                        </th> -->
                                                    </tr>
                                                </thead>

                                                <tbody>
                                                    <template x-for="(payment, index) in payments" :key="index">
                                                        <tr>
                                                            <!-- Amount -->
                                                            <td class="p-2">
                                                                <input type="number" step="0.01" :name="'payments['+index+'][amount]'" x-model="payment.amount"
                                                                    class="form-input w-full rounded border border-slate-300 px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                                                    placeholder="Amount">
                                                            </td>

                                                            <!-- Currency -->
                                                            <td class="p-2">
                                                                <select :name="'payments['+index+'][currency]'" x-model="payment.currency"
                                                                    class="form-select w-full rounded border border-slate-300 px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent">
                                                                    <option value="usd">USD</option>
                                                                    <option value="khr">KHR</option>
                                                                </select>
                                                            </td>

                                                            <!-- Payment Method -->
                                                            <!-- <td class="p-2">
                                                                <select :name="'payments['+index+'][payment_method]'" x-model="payment.payment_method"
                                                                    class="form-select w-full rounded border border-slate-300 px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent">
                                                                    <option value="cash">Cash</option>
                                                                    <option value="transfer">Transfer</option>
                                                                </select>
                                                            </td> -->

                                                            <!-- Remove Button -->
                                                            <!-- <td class="p-2 text-center">
                                                                <button type="button" @click="removeRow(index)"
                                                                    class="btn rounded-full bg-red-500 text-white hover:bg-red-600">
                                                                    Remove
                                                                </button>
                                                            </td> -->
                                                        </tr>
                                                    </template>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>


                                  <!-- Form Buttons -->
                                <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                                    <a href="{{ route('driver-collect-payment.index') }}"
                                        class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                                        Cancel
                                    </a>
                                    <button
                                        type="submit"
                                        class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2 flex items-center justify-center gap-2 disabled:opacity-70"
                                        :disabled="loading"
                                    >
                                        <!-- Spinner -->
                                        <svg
                                            x-show="loading"
                                            class="w-4 h-4 animate-spin text-white"
                                            xmlns="http://www.w3.org/2000/svg"
                                            fill="none"
                                            viewBox="0 0 24 24"
                                        >
                                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                            <path class="opacity-75" fill="currentColor"
                                                d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                                            </path>
                                        </svg>

                                        <!-- Text -->
                                        <span x-show="!loading">
                                             {{ isset($summary) ? 'Update Invoice Shop' : 'Generated Invoice Shop' }} 
                                        </span>
                                        <span x-show="loading">
                                            Processing...
                                        </span>
                                    </button>

                                </div>

                                
                            </form>
                           
                        </div>
                    </div>


                </div>
            </div>
        </div>

             <!-- Payment Modal -->
    @include('pages.driver-collect-payment.payment-modal')

    </main>
</x-app-layout>


@stack('scripts')
<script>

    document.addEventListener('DOMContentLoaded', () => {
        document.querySelectorAll('.adjust-payment').forEach(button => {
            button.addEventListener('click', () => {
                const data = button.getAttribute('data-payment');

                try {
                    const parsed = JSON.parse(data);
                    window.dispatchEvent(new CustomEvent('open-status-modal', { detail: parsed }));
                } catch (e) {
                    alert('Failed to parse payment data');
                    console.error('Invalid JSON in data-payment:', data);
                }
            });
        });
    });





    function paymentForm(existingPayments = [], totalUsd = 0, totalKhr = 0) {
        return {
            payments: existingPayments.length
                ? existingPayments
                : [
                    { amount: totalUsd, currency: 'usd', payment_method: 'cash' },
                    { amount: totalKhr, currency: 'khr', payment_method: 'cash' }
                ],
            addRow() {
                this.payments.push({ amount: '', currency: 'usd', payment_method: 'cash' });
            },
            removeRow(index) {
                this.payments.splice(index, 1);
            }
        }
    }
</script>
