<!-- Simple Generate Invoice Modal -->
<div
    x-data="generateInvoiceModal()"
    x-cloak
    id="invoiceModal"
    x-on:open-invoice-modal.window="open($event.detail.customerId)"
>
    <div
        class="fixed inset-0 z-100 flex items-center justify-center px-4 py-6 sm:px-5"
        x-show="showModal"
        role="dialog"
        @keydown.window.escape="showModal = false"
        x-transition
    >
        <!-- Overlay -->
        <div
            class="absolute inset-0 bg-slate-900/60"
            @click="showModal = false"
        ></div>

        <!-- Modal Content -->
        <div class="relative w-full max-w-md rounded-lg bg-white dark:bg-navy-700">
            <!-- Header -->
            <div class="flex justify-between items-center border-b px-4 py-3">
                <h3 class="text-base font-medium">
                    Confirm Generate Invoice
                </h3>
                <button class="cursor-pointer" @click="showModal = false">✕</button>
            </div>

            <!-- Body -->
            <div class="p-4 text-center">
                <p class="text-sm">
                    Are you sure you want to generate invoice for #
                    <span x-text="customerId"></span>?
                </p>
            </div>

            <!-- Footer -->
            <div class="flex justify-end gap-2 border-t px-4 py-3">
                <button type="button" @click="showModal = false"  
               class="btn border border-red-400 bg-red-100 text-red-600 font-medium 
                                hover:bg-red-200 focus:bg-red-200 active:bg-red-300 
                                dark:border-red-400 dark:bg-red-700 dark:text-white 
                                dark:hover:bg-red-600 dark:focus:bg-red-600 dark:active:bg-red-500">
                    Cancel
                </button>

                <button type="button"
                    @click="submitGenerate"
                    :disabled="isLoading"
                    class="btn border border-primary/30 bg-primary/10 font-medium text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:border-accent-light/30 dark:bg-accent-light/10 dark:text-accent-light dark:hover:bg-accent-light/20 dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25">
                    <span x-show="!isLoading">Generate</span>
                    <span x-show="isLoading">Processing...</span>
                </button>
            </div>
        </div>
    </div>
</div>
<script>
function generateInvoiceModal() {
    return {
        showModal: false,
        customerId: null,
        isLoading: false,

        open(customerId) {
            this.customerId = customerId;
            this.showModal = true;
        },

        submitGenerate() {
            this.isLoading = true;

            fetch(`{{ route('generatedInvoice', ':id') }}`.replace(':id', this.customerId), {
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    this.showModal = false;
                    $('.data-table').DataTable().ajax.reload(null, false);

                    this.$notification({
                        text: data.message || 'Invoice generated successfully!',
                        variant: 'success',
                        position: 'center-top',
                        duration: 5000
                    });
                } else {
                    this.$notification({
                        text: data.message || 'Failed to generate invoice.',
                        variant: 'error',
                        position: 'center-top',
                        duration: 5000
                    });
                }
            })
            .catch(() => {
                this.$notification({
                    text: 'Server or network error.',
                    variant: 'error',
                    position: 'center-top',
                    duration: 5000
                });
            })
            .finally(() => {
                this.isLoading = false;
            });
        }
    }
}
</script>
