<x-app-layout title="Delivery Edit" is-header-blur="false" is-sidebar-open="true" header-sticky="false" has-min-sidebar="false">



    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">Delivery</h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">List</a>
                    <svg x-ignore xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>Edit</li>
            </ul>

            <!-- Back Button -->
            <div class="ml-auto">
                <a href="{{ route('delivery.index') }}" class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">Back</a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
            <div>
                <div class="card p-2 mt-3">
                    


                    <div class="card">
                        <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 ">
                            <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
                            Edit Delivery
                            </h2>
                        </div>

                        <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
                            <form method="POST" action="{{ route('delivery.update', $delivery->id) }}" enctype="multipart/form-data" class="space-y-4" id="deliveryForm">
                                @csrf
                                @method('PUT')

                                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">

                                    <!-- Customer Name -->
                                    <label class="block">
                                        <span>Customer Name <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <span class="relative mt-1.5 flex">
                                            <select disabled
                                                    class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary disabled:pointer-events-none disabled:select-none disabled:border-none disabled:bg-zinc-100 dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent dark:disabled:bg-navy-600"
                                                    >
                                                <option value="">Select customer</option>
                                                @foreach($customer as $customerOption)
                                                    <option value="{{ $customerOption->id }}" {{ old('customer_id', $delivery->customer_id) == $customerOption->id ? 'selected' : '' }}>
                                                        {{ $customerOption->customer_name }} {{ $customerOption->phone }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </span>
                                        @error('customer_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>

                                    <!-- Pick Up By -->
                                    <label class="block">
                                        <span>Pick Up By <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <span class="relative mt-1.5 flex">
                                           <select disabled name="pickup_by" id="pickupBy"
                                                    class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary disabled:pointer-events-none disabled:select-none disabled:border-none disabled:bg-zinc-100 dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent dark:disabled:bg-navy-600"
                                                    >
                                              <option value="">Select PickUp By</option>
                                                @foreach($pickupBy as $id => $name)
                                                    <option value="{{ $id }}" {{ old('pickup_by', $delivery->pickup_by) == $id ? 'selected' : '' }}>
                                                        {{ $name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </span>
                                        @error('pickup_by') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>

                                    <!-- Zone -->
                                    <label class="block">
                                        <span>Zone</span>
                                        <span class="relative mt-1.5 flex">
                                            <select name="zone_price_id" id="zonePrice"
                                                class="form-select w-full rounded-full border border-slate-300 bg-transparent px-4 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent">
                                                <option value="">Select Zone</option>
                                                @foreach($zone as $id => $zoneData)
                                                    <option value="{{ $zoneData->id }}" data-address="{{ $zoneData->zone_name }}" data-price="{{ $zoneData->price }}"
                                                        {{ old('zone_price_id', $delivery->zone_price_id) == $zoneData->id ? 'selected' : '' }}>
                                                        {{ $zoneData->zone_name }} - ${{ $zoneData->price }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </span>
                                        @error('zone_price_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>

                                    <!-- Receiver Address -->
                                    <label class="block">
                                        <span>Receiver Address <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <span class="relative mt-1.5 flex">
                                            <input type="text" id="receiverAddress" name="receiver_address" value="{{ old('receiver_address', $delivery->receiver_address) }}"
                                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                                placeholder="Receiver Address">
                                            <span
                                                class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                                <i class="fa fa-address-card"></i>
                                            </span>
                                        </span>
                                        @error('receiver_address') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>

                                    <!-- Delivery Price -->
                                    <label class="block">
                                        <span>Delivery Price <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <span class="relative mt-1.5 flex">
                                            <input type="text" id="deliveryPrice" name="delivery_price" value="{{ old('delivery_price', $delivery->delivery_price) }}"
                                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                                placeholder="Delivery Price">
                                            <span
                                                class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                                <i class="fa fa-money-bill"></i>
                                            </span>
                                        </span>
                                        @error('delivery_price') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>

                                    <!-- Receiver Phone -->
                                    <label class="block">
                                        <span>Receiver Phone <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <span class="relative mt-1.5 flex">
                                            <input type="text" name="receiver_phone" value="{{ old('receiver_phone', $delivery->receiver_phone) }}"
                                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                                placeholder="Receiver Phone">
                                            <span
                                                class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                                <i class="fa fa-phone"></i>
                                            </span>
                                        </span>
                                        @error('receiver_phone') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>

                                    <!-- Type of Delivery -->
                                    <label class="block">
                                        <span>Type Of Delivery <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <span class="relative mt-1.5 flex">
                                            <label class="inline-flex items-center space-x-2 mr-4">
                                                <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                                    name="type_of_delivery" type="radio" value="Normal" {{ old('type_of_delivery', $delivery->type_of_delivery) == 'Normal' ? 'checked' : '' }} />
                                                <p>Normal</p>
                                            </label>
                                            <label class="inline-flex items-center space-x-2 mr-4">
                                                <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                                    name="type_of_delivery" type="radio" value="Express" {{ old('type_of_delivery', $delivery->type_of_delivery) == 'Express' ? 'checked' : '' }} />
                                                <p>Express</p>
                                            </label>
                                        </span>
                                        @error('type_of_delivery') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>

                                    <!-- COD -->
                                    <label class="block">
                                        <span>COD <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <span class="relative mt-1.5 flex">
                                            <label class="inline-flex items-center space-x-2 mr-4">
                                                <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                                    name="type_of_cod" type="radio" value="Yes" {{ old('type_of_cod', $delivery->type_of_cod) == 'Yes' ? 'checked' : '' }} />
                                                <p>Yes</p>
                                            </label>
                                            <label class="inline-flex items-center space-x-2 mr-4">
                                                <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                                    name="type_of_cod" type="radio" value="No" {{ old('type_of_cod', $delivery->type_of_cod) == 'No' ? 'checked' : '' }} />
                                                <p>No</p>
                                            </label>
                                        </span>
                                        @error('type_of_cod') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>


                                  

                                    <!-- Amount USD -->
                                    <label class="block">
                                        <span>Amount USD</span>
                                        <span class="relative mt-1.5 flex">
                                            <input type="text" name="amount_usd" value="{{ old('amount_usd', $delivery->amount_usd) }}"
                                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                                placeholder="Amount USD">
                                            <span
                                                class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                                <i class="fa fa-dollar-sign"></i>
                                            </span>
                                        </span>
                                        @error('amount_usd') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>

                                    <!-- Amount KHR -->
                                    <label class="block">
                                        <span>Amount KHR</span>
                                        <span class="relative mt-1.5 flex">
                                            <input type="text" name="amount_khr" value="{{ old('amount_khr', $delivery->amount_khr) }}"
                                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                                placeholder="Amount KHR">
                                            <span
                                                class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                                <i class="fa fa-money-bill-wave"></i>
                                            </span>
                                        </span>
                                        @error('amount_khr') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>


                                      <!-- Any Extra Fee -->
                                    <label class="block">
                                        <span>Any Extra Fee</span>
                                        <span class="relative mt-1.5 flex">
                                            <input type="text" name="any_extra_fee" value="{{ old('any_extra_fee', $delivery->any_extra_fee) }}"
                                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                                placeholder="Taxi | add more fee">
                                            <span
                                                class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                                <i class="fa fa-dollar-sign"></i>
                                            </span>
                                        </span>
                                        @error('any_extra_fee') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>


                                     <!-- Who -->
                                    <label class="block">
                                        <span>Who Pay Fee <span class="text-red-300 text-xs mt-1">*</span></span>
                                        <span class="relative mt-1.5 flex">
                                            <label class="inline-flex items-center space-x-2 mr-4">
                                                <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                                    name="who_pay_fee" type="radio" value="Driver" {{ old('who_pay_fee', $delivery->who_pay_fee) == 'Driver' ? 'checked' : '' }} />
                                                <p>Driver</p>
                                            </label>
                                            <label class="inline-flex items-center space-x-2 mr-4">
                                                <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                                    name="who_pay_fee" type="radio" value="Company" {{ old('who_pay_fee', $delivery->who_pay_fee) == 'Company' ? 'checked' : '' }} />
                                                <p>Company</p>
                                            </label>
                                            <label class="inline-flex items-center space-x-2 mr-4">
                                                <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                                    name="who_pay_fee" type="radio" value="Shop" {{ old('who_pay_fee', $delivery->who_pay_fee) == 'Shop' ? 'checked' : '' }} />
                                                <p>Shop</p>
                                            </label>
                                        </span>
                                        @error('who_pay_fee') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>


                                    <label class="block sm:col-span-2">
                                        <span>note</span>
                                        <textarea name="note" rows="2"
                                            class="form-input peer mt-1.5 w-full rounded border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                            placeholder="Enter note">{{ old('note', $delivery->note ?? '') }}</textarea>
                                        @error('note') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                                    </label>
                                
                                 
                                </div>

                                <!-- Form Buttons -->
                                <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                                    <a href="{{ route('delivery.index') }}"
                                        class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                                        Cancel
                                    </a>
                                    <button type="submit"
                                        class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2">
                                        Update Inquiry
                                    </button>
                                </div>
                            </form>
                           
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </main>
</x-app-layout>
<script>

    document.addEventListener('DOMContentLoaded', function () {
        const zonePriceSelect = document.getElementById('zonePrice');
        const receiverAddressInput = document.getElementById('receiverAddress');
        const deliveryPriceInput = document.getElementById('deliveryPrice');
        const typeOfDeliveryRadios = document.querySelectorAll('input[name="type_of_delivery"]');
        let basePrice = parseFloat(deliveryPriceInput.value) || 0;

        zonePriceSelect.addEventListener('change', function () {
            const selectedOption = this.options[this.selectedIndex];
            const zoneId = selectedOption.value;

            receiverAddressInput.value = selectedOption.getAttribute('data-address') || '';
            deliveryPriceInput.value = selectedOption.getAttribute('data-price') || '';
            basePrice = parseFloat(selectedOption.getAttribute('data-price')) || 0;

            const selectedType = document.querySelector('input[name="type_of_delivery"]:checked');
            if (selectedType && selectedType.value === 'Express') {
                fetchExpressFee(zoneId).then(fee => {
                    deliveryPriceInput.value = (basePrice + fee).toFixed(2);
                });
            }
        });

        typeOfDeliveryRadios.forEach(radio => {
            radio.addEventListener('change', function () {
                const selectedOption = zonePriceSelect.options[zonePriceSelect.selectedIndex];
                const zoneId = selectedOption.value;

                if (this.value === 'Express') {
                    fetchExpressFee(zoneId).then(fee => {
                        deliveryPriceInput.value = (basePrice + fee).toFixed(2);
                    });
                } else {
                    deliveryPriceInput.value = basePrice.toFixed(2);
                }
            });
        });

        // Function to fetch express fee from server
        function fetchExpressFee(zoneId) {
            return fetch(`{{ route('getExpressFee') }}?zone_id=${zoneId}`)
                .then(response => response.json())
                .then(data => data.express_fee || 0)
                .catch(error => {
                    console.error('Error fetching express fee:', error);
                    return 0;
                });
        }
    });
</script>

</script>
