<x-app-layout title="Delivery" is-header-blur="false" is-sidebar-open="true" header-sticky="true" has-min-sidebar="false">

     <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                Delivery
            </h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a
                        class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent"
                        href="#"
                    >List</a>
                    <svg
                        x-ignore
                        xmlns="http://www.w3.org/2000/svg"
                        class="size-4"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                    >
                        <path
                            stroke-linecap="round"
                            stroke-linejoin="round"
                            stroke-width="2"
                            d="M9 5l7 7-7 7"
                        />
                    </svg>
                </li>
                <li>All</li>
            </ul>

            <!-- Add New Button -->
            <div class="ml-auto">
                 @can('delivery.assign')
                <!-- Assign Driver -->
                <a href="{{ route('assign-driver.index') }}">
                    <div class="badge p-2 space-x-2 bg-blue-100 text-blue-800 dark:bg-blue-500 dark:text-white">
                        <i class="fas fa-user-plus"></i>
                        <span>Assign driver</span>
                    </div>
                </a>
                @endcan
                @can('delivery.transfer')
                <!-- Change/Transfer Driver -->
                <a href="{{ route('change-driver.index') }}">
                    <div class="badge p-2 space-x-2 bg-purple-100 text-purple-800 dark:bg-purple-500 dark:text-white">
                        <i class="fas fa-people-arrows"></i>
                        <span>Transfer driver</span>
                    </div>
                </a>
                @endcan
                @can('delivery.remove')
                <!-- Remove Delivery -->
                <a href="{{ route('remove-delivery.index') }}">
                    <div class="badge p-2 space-x-2 bg-red-100 text-red-800 dark:bg-red-500 dark:text-white">
                        <i class="fas fa-trash"></i>
                        <span>Remove or delete</span>
                    </div>
                </a>
                @endcan
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-3 lg:grid-cols-6 gap-4 mt-4 card p-2">
            <div x-data="{ dateValue: '' }">
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">Entry Date</span>
                    <label class="relative flex mt-1.5">
                        <input
                            id="entryFilter"
                            name="entry_at"
                            x-model="dateValue"
                            x-init="
                                flatpickr($el, {
                                    mode: 'range',
                                    dateFormat: 'Y-m-d',
                                    defaultDate: null,
                                    onChange: function(selectedDates, dateStr, instance) {
                                        dateValue = dateStr;
                                    }
                                });
                            "
                            class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 pr-10 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Choose date..."
                            type="text"
                            x-ref="entryDateInput"
                        />

                        <span
                            class="pointer-events-none absolute left-0 flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="size-5 transition-colors duration-200" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </span>

                        <button
                            type="button"
                            x-show="dateValue"
                            @click="dateValue = ''; $refs.entryDateInput._flatpickr.clear()"
                            class="absolute right-2 top-2 text-slate-400 hover:text-red-500 focus:outline-none"
                            title="Clear"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </label>
                </label>
            </div>


            <div x-data="{ dateValue: '' }">
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">Completed Date</span>
                    <label class="relative flex mt-1.5">
                        <input
                            id="completedFilter"
                            name="completed_at"
                            x-model="dateValue"
                            x-init="
                                flatpickr($el, {
                                    mode: 'range',
                                    dateFormat: 'Y-m-d',
                                    defaultDate: null,
                                    onChange: function(selectedDates, dateStr, instance) {
                                        dateValue = dateStr;
                                    }
                                });
                            "
                            class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 pr-10 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Choose date..."
                            type="text"
                            x-ref="entryDateInput"
                        />

                        <span
                            class="pointer-events-none absolute left-0 flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="size-5 transition-colors duration-200" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </span>

                        <button
                            type="button"
                            x-show="dateValue"
                            @click="dateValue = ''; $refs.entryDateInput._flatpickr.clear()"
                            class="absolute right-2 top-2 text-slate-400 hover:text-red-500 focus:outline-none"
                            title="Clear"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </label>
                </label>
            </div>



            <div x-data>
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">Delivery By</span>
                    <select name="delivery_by" id="deliveryFilter"
                        x-init="$nextTick(() => new TomSelect($el, {
                            create: false,
                            sortField: {
                                field: 'text',
                                direction: 'asc'
                            },
                            placeholder: 'Search or select an driver...',
                            }))"
                        class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                        >
                        <option value="">Select an driver</option>
                        @foreach($deliveryBy as $id => $name)
                                <option value="{{ $id }}" {{ old('delivery_by') == $id ? 'selected' : '' }}>
                                {{ $name }}
                            </option>
                        @endforeach
                    </select>
                </label>
            </div>
            

            <div x-data>
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">Customer Name</span>
                    <select id="customerFilter"  name="customer_id"
                        x-init="$nextTick(() => new TomSelect($el, {
                            create: false,
                            sortField: {
                                field: 'text',
                                direction: 'asc'
                            },
                            placeholder: 'Search or select an customers...',
                            }))"
                        class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                        >
                        <option value="">Select an customer</option>
                        @foreach($customer as $customerOption)
                                    <option value="{{ $customerOption->id }}" {{ old('customer_id') == $customerOption->id ? 'selected' : '' }}>
                                    {{ $customerOption->customer_name }} {{ $customerOption->phone }}
                                </option>
                            @endforeach
                    </select>
                </label>
            </div>
            


            <div x-data>
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100">Delivery Status</span>
                    <select name="status" id="statusFilter"
                        x-init="$nextTick(() => new TomSelect($el, {
                            create: false,
                            sortField: {
                                field: 'text',
                                direction: 'asc'
                            },
                            placeholder: 'Search or select an status...',
                            }))"
                        class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                        >
                        <option value="">Select an delivery status</option>
                        @foreach ($statusOptions as $option)
                                <option value="{{ $option['value'] }}" {{ old('status_id') == $option['value'] ? 'selected' : '' }}>
                                    {{ $option['label'] }}
                                </option>
                            @endforeach
                    </select>
                </label>
            </div>
        
        </div>
        

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">

          <div>
            <div class="card p-2 mt-3">
              <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left data-table">
                  <thead>
                    <tr>
                      <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-2 py-2 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        N<sup>o</sup></th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Code
                      </th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Created Date
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Customer
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Address
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Phone
                      </th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Amount USD
                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Amount KHR
                      </th>
                     
                       <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        DeliveryBy
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Status
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Cancel
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                       EntryBy
                      </th>
                      <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Action</th>
                    </tr>
                  </thead>
                  <tbody class="gridjs-tbody">
                   
                  </tbody>
                </table>
              </div>

          
            </div>
          </div>

        </div>



     <!-- Payment Modal -->
    @include('pages.delivery.payment-modal')

    @include('pages.delivery.cancel-modal')
      </main>
</x-app-layout>


@stack('scripts')
<script>
$(function () {
    $('.data-table').DataTable({
        scrollY: '400px',         // Scrollable body
        scrollCollapse: true,     // Collapse empty space
        fixedHeader: true, 
        processing: true,
        serverSide: true,
        responsive: true,
        autoWidth: false,
        scrollX: true,
        order: [[0, 'desc']],
        pageLength: 100,
        lengthMenu: [10, 25, 50, 100,200],
        searching: true,
        ajax: {
            url: "{{ route('deliveryAjax') }}",
            data: function (d) {
                d.completed_at = $('#completedFilter').val();
                d.entry_at = $('#entryFilter').val();
                d.delivery_by = $('#deliveryFilter').val();
                d.customer_id = $('#customerFilter').val();
                d.status = $('#statusFilter').val();
            }
        },
        
        columns: [
            { data: 'id', name: 'id' },
            { data: 'code', name: 'code' },
            { data: 'created_at', name: 'created_at' },
            { data: 'customer_name', name: 'customer_name' },
            { data: 'receiver_address', name: 'receiver_address' },
            { data: 'receiver_phone', name: 'receiver_phone' },
            {
                data: 'amount_usd', name: 'amount_usd',
                render: function(data) {
                    return new Intl.NumberFormat('en-US', {
                        style: 'currency',
                        currency: 'USD',
                    }).format(data);
                }
            },
            {
                data: 'amount_khr', name: 'amount_khr',
                render: function(data) {
                    return new Intl.NumberFormat('en-US', {
                        style: 'currency',
                        currency: 'KHR',
                    }).format(data);
                }
            },
            { data: 'delivery_by', name: 'delivery_by' },
            {
                data: 'status_label',
                name: 'status_label',
                render: function (data, type, row) {
                    const isClickable = (row.status == 'assigned' || row.status == 'delivered');
                    const cursorClass = isClickable ? 'cursor-pointer' : 'cursor-not-allowed opacity-50';

                    return `
                        <div 
                            class="${cursorClass}" 
                            onclick="${isClickable
                                ? `window.dispatchEvent(new CustomEvent('open-status-modal', { detail: { deliveryId: ${row.id}, amountUsd: ${row.amount_usd}, amountKhr: ${row.amount_khr} } }))`
                                : `alert('Payment is only allowed when the status is Assigned or Delivered.')`
                            }"
                        >
                            ${data}
                        </div>
                    `;
                }
            },

           {
            data: 'status_cancel',
            name: 'status_cancel',
            render: function (data, type, row) {
                const isClickable = row.status !== 'completed';
                const cursorClass = isClickable ? 'cursor-pointer' : 'cursor-not-allowed opacity-50';

                const deliveryId = row.id;
                const cancelReasonNote = JSON.stringify(row.cancel_note || '');
                const cancelReasonId = row.cancel_reason_id;

                const onclick = isClickable
                    ? `window.dispatchEvent(new CustomEvent('open-status-cancel-modal', { detail: { deliveryId: ${deliveryId}, note: ${cancelReasonNote}, cancelReasonId: ${cancelReasonId} }}))`
                    : `alert('You can only cancel if the delivery is not completed.')`;

                return `
                    <div 
                        class="${cursorClass}" 
                        style="white-space: nowrap"
                        onclick="${onclick.replace(/"/g, '&quot;')}"
                    >
                        ${data}
                    </div>
                `;
            }
        },

                
            { data: 'created_by', name: 'created_by' },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
        dom: "<'flex flex-col md:flex-row justify-between items-center mb-4'lf>tr<'flex flex-col md:flex-row justify-between items-center mt-4'ip>",
        language: {
            lengthMenu: "Show _MENU_ entries",
            search: "Search:",
            zeroRecords: "No matching records found",
             paginate: {
                 previous: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                    </svg>
                `,
                next: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                    </svg>
                `
            }
        },
         createdRow: function (row, data, dataIndex) {

            $(row).addClass(' hover:bg-slate-50 dark:hover:bg-navy-800');
            $('td', row).addClass('whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500');

        },
        drawCallback: function () {

            $('.dataTables_paginate .paginate_button')
            .addClass('flex mr-1 ml-1 h-8 min-w-[2rem] items-center justify-center bg-primary rounded-full bg-slate-150 px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90');

            $('.dataTables_paginate .paginate_button.previous, .dataTables_paginate .paginate_button.next')
                .addClass('flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90')
                .removeClass('px-3 min-w-[2rem]'); 

        }
    });

    $('.dataTables_filter input').addClass('form-input w-full rounded-full border border-slate-300 bg-transparent px-4 py-1 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_filter label').addClass('flex items-center space-x-2');
    $('.dataTables_length select').addClass('form-select rounded-full border border-slate-300 bg-white px-3 py-1 pr-6 text-xs-plus hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:text-navy-100 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_length label').addClass('flex items-center space-x-2');


});
$('#entryFilter, #completedFilter, #deliveryFilter, #customerFilter, #statusFilter').on('change', function () {
    $('.data-table').DataTable().ajax.reload();
});





                    
       

</script>

