<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 ">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
            {{ isset($user) ? 'Edit User' : 'Create User' }}
        </h2>
    </div>
    <div class="border border-slate-200 p-2 dark:border-navy-500  p-2 mt-3">
        <form method="POST" action="{{ isset($user) ? route('users.update', $user->id) : route('users.store') }}">
            @csrf
            @if(isset($user))
                @method('PUT')
            @endif

            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                {{-- Display Name --}}
                <label class="block">
                    <span>Display Name</span>
                    <span class="relative mt-1.5 flex">
                        <input name="display_name" value="{{ old('display_name', $user->display_name ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Enter name" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-user text-base"></i>
                        </span>
                    </span>
                    @error('display_name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

              
                <label class="block">
                    <span>Username <span class="text-red-500 text-xs mt-1">*</span></span>
                    <span class="relative mt-1.5 flex">
                        <input name="name" value="{{ old('name', $user->name ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Enter full name" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-user text-base"></i>
                        </span>
                    </span>
                    @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                
                <label class="block">
                    <span>Email Address </span>
                    <span class="relative mt-1.5 flex">
                        <input name="email" value="{{ old('email', $user->email ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Enter email address" type="email" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-envelope text-base"></i>
                        </span>
                    </span>
                    @error('email') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                <label class="block">
                    <span>Phone Number <span class="text-red-500 text-xs mt-1">*</span></span>
                    <span class="relative mt-1.5 flex">
                        <input name="phone" value="{{ old('phone', $user->phone ?? '') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Enter phone number" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa fa-phone"></i>
                        </span>
                    </span>
                    @error('phone') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                <label class="block">
                    <span>Gender <span class="text-red-500 text-xs mt-1">*</span></span>
                    <span class="relative mt-1.5 flex">
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="gender" type="radio" value="male" {{ old('gender', $user->gender ?? 'male') == 'male' ? 'checked' : '' }} />
                            <p>Male</p>
                        </label>
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="gender" type="radio" value="female" {{ old('gender', $user->gender ?? '') == 'female' ? 'checked' : '' }} />
                            <p>Female</p>
                        </label>
                    </span>
                    @error('gender') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                <label class="block">
                    <span>Status <span class="text-red-500 text-xs mt-1">*</span></span>
                    <span class="relative mt-1.5 flex">
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="status" type="radio" value="active" {{ old('status', $user->status ?? 'active') == 'active' ? 'checked' : '' }} />
                            <p>Active</p>
                        </label>
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="status" type="radio" value="inactive" {{ old('status', $user->status ?? '') == 'inactive' ? 'checked' : '' }} />
                            <p>Inactive</p>
                        </label>
                    </span>
                    @error('status') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

             
                <label class="block">
                    <span>Please choose branches <span class="text-red-500 text-xs mt-1">*</span></span>
                    <div class="mt-1 grid grid-cols-2 place-items-start gap-6 sm:grid-cols-3 border border-slate-200 p-2 rounded-lg dark:border-navy-500">
                    @foreach($branches as $branch)
                    <label class="inline-flex items-center space-x-2 mt-2">
                        <input
                        class="form-checkbox is-outline size-5 rounded-md border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                        name="branches[]"
                        type="checkbox"
                        value="{{ $branch->id }}"
                        @if(collect(old('branches', isset($user) ? $user->branches->pluck('id')->toArray() : []))->contains($branch->id)) checked @endif
                        />
                        <p>{{ $branch->name }}</p>
                    </label>
                    @endforeach

                    @error('branches')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                    </div>
                </label>


              
                <label class="block">
                    <span>Please choose roles? <span class="text-red-500 text-xs mt-1">*</span></span>
                    <select name="role" class="form-select mt-1.5 w-full rounded-full border border-slate-300 bg-white px-4 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent">
                        <option value="">Select Role</option>
                    @foreach($roles as $role)
                            <option value="{{ $role->name }}" 
                                {{ old('role', isset($user) && $user->roles->first() ? $user->roles->first()->name : '') == $role->name ? 'selected' : '' }}>
                                {{ $role->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('role') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                @if (!isset($user))
                    <label class="block" x-data="{ show: false }">
                        <span>Password <span class="text-red-500 text-xs mt-1">*</span></span>
                        <span class="relative mt-1.5 flex">
                            <input :type="show ? 'text' : 'password'" name="password"
                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 pr-10 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                placeholder="Enter password" />
                            <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                <i class="fa fa-lock text-base"></i>
                            </span>
                            <button type="button" @click="show = !show"
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-400 hover:text-primary dark:text-navy-300 dark:hover:text-accent">
                                <i :class="show ? 'fa fa-eye-slash' : 'fa fa-eye'"></i>
                            </button>
                        </span>
                        @error('password') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                    </label>

                    <label class="block" x-data="{ show: false }">
                        <span>Confirm Password <span class="text-red-500 text-xs mt-1">*</span></span>
                        <span class="relative mt-1.5 flex">
                            <input :type="show ? 'text' : 'password'" name="password_confirmation"
                                class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 pr-10 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                placeholder="Confirm password" />
                            <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                <i class="fa fa-lock text-base"></i>
                            </span>
                            <button type="button" @click="show = !show"
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-400 hover:text-primary dark:text-navy-300 dark:hover:text-accent">
                                <i :class="show ? 'fa fa-eye-slash' : 'fa fa-eye'"></i>
                            </button>
                        </span>
                    </label>
                @endif
            </div>

          
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="{{ route('users.index') }}"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-700 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90">
                    Cancel
                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90 ml-2">
                    {{ isset($user) ? 'Update' : 'Save' }}
                </button>
            </div>
        </form>
    </div>
</div>