<x-base-layout title="{{ config('app.name') }}">
    <div class="fixed w-full top-0 p-2 border-b border-slate-200 dark:border-navy-500 bg-white dark:bg-navy-700 z-50">
    <div class="flex items-center justify-between">

        <a href="{{ route('dashboards.index') }}" class="flex items-center space-x-2">
             @if($currentBranch && $currentBranch->logo)
                <img class="size-12" src="{{ asset('storage/'. $currentBranch->logo) }}" alt="logo" />
            @else
                <img class="size-12" src="{{ asset('images/app-logo.svg') }}" alt="logo" />
            @endif
            <p class="text-xl font-semibold uppercase text-slate-700 dark:text-navy-100">
                {{ config('app.name') }}
            </p>
        </a>
        <div class="flex items-center space-x-4">
            @if (auth()->check())
            <a href="{{ route('dashboards.index') }}" class="text-sm font-medium text-slate-600 dark:text-navy-100 hover:underline">
                <span class="text-sm text-slate-600 dark:text-navy-100">
                    Welcome, {{ auth()->user()->name }}
                </span>
            </a>
            @else
                 <a href="{{ route('login') }}" class="text-sm font-medium text-slate-600 dark:text-navy-100 hover:underline">
                    Login
                </a>
            @endif
        </div>
    </div>
</div>


    <div class="w-full place-items-center lg:grid">
        <div class="w-full max-w-lg p-6">
           <div class="mt-12" x-data="trackingSearch()" x-init="init()">
                <h3 class="text-center text-lg font-semibold text-slate-600 dark:text-navy-100 mb-4">
                    Track Your Delivery
                </h3>

                <div class="flex w-full max-w-md space-x-2 mb-4 border-b border-slate-200 dark:border-navy-500 pb-4">
                    <div class="relative flex w-full" >
                        <input type="text" x-model="trackingCode"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-slate-100 px-4 py-2 pl-10 text-sm placeholder:text-slate-400 hover:border-primary focus:border-primary focus:ring-1 focus:ring-primary dark:border-navy-450 dark:bg-navy-700 dark:placeholder:text-navy-300 dark:hover:border-accent dark:focus:border-accent dark:focus:ring-accent"
                            placeholder="Enter tracking code">
                        <span
                            class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fas fa-route"></i>
                        </span>
                    </div>

                    <button @click="search"
                        class="btn h-10 rounded-full bg-primary px-4 text-sm font-medium text-white hover:bg-primary-focus focus:outline-none focus:ring-2 focus:ring-primary dark:bg-accent dark:hover:bg-accent-focus dark:focus:ring-accent">
                        Search
                    </button>
                </div>

                <!-- Error Message -->
                <template x-if="errorMessage">
                    <div class="mt-4 text-center text-error" x-text="errorMessage"></div>
                </template>

                <!-- Loading Spinner -->
                <template x-if="isLoading">
                    <div class="mt-4 text-center text-slate-500 dark:text-navy-300">Loading...</div>
                </template>

                <!-- Delivery Timeline -->
                <template x-if="statuses.length > 0">
                    <ol class="timeline max-w-xl mx-auto mt-2"> 
                        <h2 class="text-start text-md font-semibold text-slate-600 dark:text-navy-100 mt-6 mb-4">
                            Status History
                         </h2>
                        <template x-for="status in statuses" :key="status.id">
                            <li class="timeline-item">
                                <div :class="`timeline-item-point rounded-full ${getColor(status.status)}`">
                                    <template x-if="status.status.toLowerCase() === 'completed'">
                                        <span :class="`inline-flex h-full w-full animate-ping rounded-full ${getColor(status.status)} opacity-80`"></span>
                                    </template>
                                </div>

                                <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                    <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                        <p class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                                            x-text="`${status.status} | ${status.changed_by ?? 'System'}`">
                                        </p>
                                        <span class="text-xs text-slate-400 dark:text-navy-300" x-text="status.diff_for_humans"></span>
                                    </div>
                                    <p class="py-1">
                                        <div class="text-xs text-slate-400 dark:text-navy-300" x-text="status.changed_at"></div>
                                        <span x-text="status.note || 'Status updated.'"></span>
                                    </p>
                                </div>
                            </li>
                        </template>
                    </ol>
                </template>
            </div>

            
        </div>
    </div>
    
</x-base-layout>
<script>
function trackingSearch() {
    return {
        trackingCode: '',
        statuses: [],
        isLoading: false,
        errorMessage: '',

        init() {
            const params = new URLSearchParams(window.location.search);
            const code = params.get('tracking');
            if (code) {
                this.trackingCode = code;
                this.search();
            }
        },

        search() {
            if (!this.trackingCode.trim()) {
                this.errorMessage = 'Please enter a tracking code.';
                return;
            }

            this.isLoading = true;
            this.errorMessage = '';
            this.statuses = [];

            fetch(`/api/search/tracking?code=${this.trackingCode}`)
                .then(response => {
                    if (!response.ok) throw new Error('Tracking code not found.');
                    return response.json();
                })
                .then(data => {
                    this.statuses = data.statuses;
                    if (this.statuses.length === 0) {
                        this.errorMessage = 'No status history found.';
                    }
                })
                .catch(error => {
                    this.errorMessage = error.message || 'Tracking code not found.';
                })
                .finally(() => {
                    this.isLoading = false;
                });
        },

        getColor(status) {
            switch (status.toLowerCase()) {
                case 'booking':
                    return 'bg-warning';
                case 'in_progress':
                    return 'bg-primary';
                case 'completed':
                    return 'bg-success';
                case 'cancelled':
                case 'returned':
                    return 'bg-error';
                default:
                    return 'bg-slate-300';
            }
        }
    }
}

</script>
