import {
  __commonJS
} from "./chunk-DC5AMYBS.js";

// node_modules/@caneara/iodine/dist/iodine.min.js
var require_iodine_min = __commonJS({
  "node_modules/@caneara/iodine/dist/iodine.min.js"(exports, module) {
    var e = class _e {
      constructor() {
        this.locale = void 0, this.messages = { after: "The date must be after: '[PARAM]'", afterOrEqual: "The date must be after or equal to: '[PARAM]'", array: "[FIELD] must be an array", before: "The date must be before: '[PARAM]'", beforeOrEqual: "The date must be before or equal to: '[PARAM]'", boolean: "[FIELD] must be true or false", date: "[FIELD] must be a date", different: "[FIELD] must be different to '[PARAM]'", endsWith: "[FIELD] must end with '[PARAM]'", email: "[FIELD] must be a valid email address", falsy: "[FIELD] must be a falsy value (false, 'false', 0 or '0')", in: "[FIELD] must be one of the following options: [PARAM]", integer: "[FIELD] must be an integer", json: "[FIELD] must be a parsable JSON object string", max: "[FIELD] must be less than or equal to [PARAM]", min: "[FIELD] must be greater than or equal to [PARAM]", maxLength: "[FIELD] must not be greater than '[PARAM]' in character length", minLength: "[FIELD] must not be less than '[PARAM]' character length", notIn: "[FIELD] must not be one of the following options: [PARAM]", numeric: "[FIELD] must be numeric", optional: "[FIELD] is optional", regexMatch: "[FIELD] must satisify the regular expression: [PARAM]", required: "[FIELD] must be present", same: "[FIELD] must be '[PARAM]'", startsWith: "[FIELD] must start with '[PARAM]'", string: "[FIELD] must be a string", truthy: "[FIELD] must be a truthy value (true, 'true', 1 or '1')", url: "[FIELD] must be a valid url", uuid: "[FIELD] must be a valid UUID" };
      }
      _compare(e2, t, r, s = false) {
        return !!this.assertDate(e2) && !(!this.assertDate(t) && !this.assertInteger(t)) && (t = "number" == typeof t ? t : t.getTime(), "less" === r && s ? e2.getTime() <= t : "less" !== r || s ? "more" === r && s ? e2.getTime() >= t : "more" !== r || s ? void 0 : e2.getTime() > t : e2.getTime() < t);
      }
      _error(e2, t = void 0) {
        let { param: r, field: s } = "object" == typeof t ? t : { param: t, field: void 0 };
        const a = e2.split(":");
        let i = a.shift();
        r = r || a.join(":"), ["after", "afterOrEqual", "before", "beforeOrEqual"].includes(i) && (r = new Date(parseInt(r)).toLocaleTimeString(this.locale, { year: "numeric", month: "short", day: "numeric", hour: "2-digit", minute: "numeric", hour12: false }));
        let n = [null, void 0, ""].includes(r) ? this.messages[i] : this.messages[i].replace("[PARAM]", r);
        return [null, void 0, ""].includes(s) ? n.replace("[FIELD]", this.default_field_name || "Value") : n.replace("[FIELD]", s);
      }
      _missing() {
        return { valid: false, rule: "None", error: "Rules exist, but no value was provided to check" };
      }
      _prepare(e2, t = []) {
        return t.length ? "optional" === t[0] && this.assertOptional(e2) ? [] : t.filter((e3) => "optional" !== e3).map((e3) => "string" == typeof e3 ? [e3, this._title(e3.split(":").shift()), e3.split(":").slice(1).join(":")] : [`${e3.rule}:${e3.param}`, this._title(e3.rule), e3.param]) : [];
      }
      _title(e2) {
        return `${e2[0].toUpperCase()}${e2.slice(1)}`;
      }
      _validate(e2, t, r = null) {
        for (let s in t = this._prepare(e2, t)) if (!this[`assert${t[s][1]}`].apply(this, [e2, t[s][2]])) return { valid: false, rule: t[s][0], error: r ? r[t[s][0]] : this._error(t[s][0]) };
        return { valid: true, rule: "", error: "" };
      }
      assert(e2, t, r = null) {
        if (Array.isArray(t)) return this._validate(e2, t, r);
        let s = Object.keys(t), a = { valid: true, fields: {} };
        for (let i = 0; i < s.length; i++) a.fields[s[i]] = e2.hasOwnProperty(s[i]) ? this._validate(e2[s[i]], t[s[i]], null != r ? r[s[i]] : null) : this._missing(), a.fields[s[i]].valid || (a.valid = false);
        return a;
      }
      assertAfter(e2, t) {
        return this._compare(e2, t, "more", false);
      }
      assertAfterOrEqual(e2, t) {
        return this._compare(e2, t, "more", true);
      }
      assertArray(e2) {
        return Array.isArray(e2);
      }
      assertBefore(e2, t) {
        return this._compare(e2, t, "less", false);
      }
      assertBeforeOrEqual(e2, t) {
        return this._compare(e2, t, "less", true);
      }
      assertBoolean(e2) {
        return [true, false].includes(e2);
      }
      assertDate(e2) {
        return e2 && "[object Date]" === Object.prototype.toString.call(e2) && !isNaN(e2);
      }
      assertDifferent(e2, t) {
        return e2 != t;
      }
      assertEndsWith(e2, t) {
        return this.assertString(e2) && e2.endsWith(t);
      }
      assertEmail(e2) {
        return new RegExp("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$").test(String(e2).toLowerCase());
      }
      assertFalsy(e2) {
        return [0, "0", false, "false"].includes(e2);
      }
      assertIn(e2, t) {
        return ("string" == typeof t ? t.split(",") : t).includes(e2);
      }
      assertInteger(e2) {
        return Number.isInteger(e2) && parseInt(e2).toString() === e2.toString();
      }
      assertJson(e2) {
        try {
          return "object" == typeof JSON.parse(e2);
        } catch (e3) {
          return false;
        }
      }
      assertMax(e2, t) {
        return parseFloat(e2) <= t;
      }
      assertMin(e2, t) {
        return parseFloat(e2) >= t;
      }
      assertMaxLength(e2, t) {
        return "string" == typeof e2 && e2.length <= t;
      }
      assertMinLength(e2, t) {
        return "string" == typeof e2 && e2.length >= t;
      }
      assertNotIn(e2, t) {
        return !this.assertIn(e2, t);
      }
      assertNumeric(e2) {
        return !isNaN(parseFloat(e2)) && isFinite(e2);
      }
      assertOptional(e2) {
        return [null, void 0, ""].includes(e2);
      }
      assertRegexMatch(e2, t) {
        return new RegExp(t).test(String(e2));
      }
      assertRequired(e2) {
        return !this.assertOptional(e2);
      }
      assertSame(e2, t) {
        return e2 == t;
      }
      assertStartsWith(e2, t) {
        return this.assertString(e2) && e2.startsWith(t);
      }
      assertString(e2) {
        return "string" == typeof e2;
      }
      assertTruthy(e2) {
        return [1, "1", true, "true"].includes(e2);
      }
      assertUrl(e2) {
        return new RegExp("^(https?:\\/\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$").test(String(e2).toLowerCase());
      }
      assertUuid(e2) {
        return new RegExp("^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$").test(String(e2).toLowerCase());
      }
      rule(t, r) {
        _e.prototype[`assert${this._title(t)}`] = r;
      }
      setErrorMessages(e2) {
        this.messages = e2;
      }
      setErrorMessage(e2, t) {
        this.messages[e2] = t;
      }
      setLocale(e2) {
        this.locale = e2;
      }
      setDefaultFieldName(e2) {
        this.default_field_name = e2;
      }
    };
    "undefined" != typeof window && (window.Iodine = new e()), module.exports = e;
  }
});
export default require_iodine_min();
//# sourceMappingURL=@caneara_iodine.js.map
