<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('ref_code')->nullable()->unique();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('branch_id')->constrained('branches')->onDelete('cascade');
            $table->string('customer_name')->nullable();
            $table->string('email')->unique()->nullable();
            $table->string('phone')->uniqidue();
            $table->string('telegram')->nullable();
            $table->string('address')->nullable();
            $table->string('status')->default('active'); // Default status is active
            $table->string('type_of_customer')->default('Normal'); // Normal, VIP or VVIP
            $table->decimal('mou_price', 10, 2)->default(0.00); // MOU service price
            $table->string('currency')->default('USD');
            $table->date('first_delivery_date')->nullable(); // First delivery date
            $table->date('last_delivery_date')->nullable(); // Last delivery date
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->string('url_map')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
