<?php

namespace App\Traits;

trait ApiResponse
{
    public function successResponse($data = null, $message = null, int $code = 200)
    {
        return response()->json([
            'success' => true,
            'message' => $message ?? 'Request successful',
            'response' => $data,
        ], $code);
    }

    public function errorResponse($errors, $message = null, int $code = 400)
    {
        $errorData = [
            'success' => false,
            'message' => $message ?? 'Request failed',
            'errors' => is_array($errors) ? $errors : [$errors],
        ];

        // Log the error
        $this->logErrorResponse($errorData);

        return response()->json($errorData, $code);
    }

    public function logResponse($data, $context = null)
    {
        \Log::info('API Response Log'.($context ? " ({$context})" : ''), ['data' => $data]);
    }

    public function logErrorResponse($data, $context = null)
    {
        \Log::warning('API Error Log'.($context ? " ({$context})" : ''), ['error' => $data]);
    }
}
