<?php

namespace App\Models;

class SummaryShopPayment extends BaseLoggableModel
{
    protected $table = 'summary_shop_payment';

    protected $fillable = [
        'invoice_number',
        'exchange_rate',
        'total_amount_usd',
        'total_amount_khr',
        'service_fee',
        'payment_date',
        'customer_id',
        'status',
        'note',
        'created_by',
        'updated_by',
        'total_new_package',
        'total_old_package',
        'completed',
        'assigned',
        'canceled',
        'return',
        'in_stock',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function confirmPayments()
    {
        return $this->hasMany(ConfirmShopPayment::class, 'summary_shop_payment_id');
    }

    public function customerPayments()
    {
        return $this->hasMany(ShopCollectDeliveryPayment::class, 'summary_shop_payment_id');
    }
}
