<?php

namespace App\Models;

class ExchangeRate extends BaseLoggableModel
{
    protected $table = 'exchange_rate';

    protected $fillable = [
        'branch_id',
        'currency_from',
        'currency_to',
        'rate',
        'status',
    ];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
