<?php

namespace App\Models;

class DeliveryStatusHistory extends BaseLoggableModel
{
    protected $table = 'delivery_status_histories';

    protected $fillable = [
        'delivery_id',
        'status',
        'changed_by',
        'changed_at',
        'note',
    ];

    public function delivery()
    {
        return $this->belongsTo(Delivery::class);
    }

    public function changedBy()
    {
        return $this->belongsTo(User::class, 'changed_by');
    }
}
