<?php

namespace App\Models;

class CustomerBankQrCode extends BaseLoggableModel
{
    protected $table = 'customers_bank';

    protected $fillable = [
        'customer_id',
        'bank_id',
        'bank_account_name',
        'bank_account_number',
        'qr_code',
        'status',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }

    public function qrCodes()
    {
        return $this->hasMany(CustomerBankQrCode::class);
    }
}
