<?php

namespace App\Models;

class ConfirmDriverPayment extends BaseLoggableModel
{
    protected $table = 'confirm_driver_payment';

    protected $fillable = [
        'summary_id',
        'driver_id',
        'amount',
        'currency',
        'payment_method',
    ];

    public function summary()
    {
        return $this->belongsTo(SummaryDriverPayment::class, 'summary_id');
    }

    public function driver()
    {
        return $this->belongsTo(User::class, 'driver_id');
    }
}
