<?php

namespace App\Models;

class AssignZone extends BaseLoggableModel
{
    protected $table = 'assign_zone';

    protected $fillable = [
        'driver_id',
        'zone_price_id',
        'branch_id',
        'created_by',
        'updated_by',
        'status',
    ];

    public function zonePrices()
    {
        return $this->hasMany(ZonePrice::class, 'id', 'zone_price_id');
    }

    public function driver()
    {
        return $this->belongsTo(User::class);
    }
}
