<?php

namespace App\Main;

class SidebarPanel
{
    public static function dashboards()
    {
        return [
            'title' => 'Dashboard Management',
            'items' => [
                [
                    'dashboard' => [
                        'title' => '1 - Dashboard',
                        'route_name' => 'dashboards',
                        'permission' => 'dashboards.view',
                    ],
                    // 'driver_dashboard' => [
                    //     'title' => '2 - Driver Summary',
                    //     'route_name' => 'driver-summary-dashboard',
                    //     'permission' => 'driver-summary-dashboard.view',
                    // ],
                    // 'customer_dashboard' => [
                    //     'title' => '3 - Customer Summary',
                    //     'route_name' => 'customer-summary-dashboard',
                    //     'permission' => 'customer-summary-dashboard.view',
                    // ],
                ],

            ],
        ];
    }

    public static function customer()
    {
        return [
            'title' => 'Customers',
            'items' => [
                [
                    'list_all_customer' => [
                        'title' => 'List all customers',
                        'route_name' => 'customer',
                        'permission' => 'customers.view',
                    ],
                ],

            ],
        ];
    }

    public static function booking()
    {
        return [
            'title' => 'Manage Booking',
            'items' => [
                [
                    'list_all_booking' => [
                        'title' => '1 - List all booking',
                        'route_name' => 'booking',
                        'permission' => 'delivery.view',
                    ],
                    'create_booking_order' => [
                        'title' => '2 - Add New Booking',
                        'route_name' => 'booking-order',
                        'permission' => 'delivery.create',
                    ],
                    'transit_list' => [
                        'title' => '3 - Transit',
                        'route_name' => 'transit',
                        'permission' => 'delivery.create',
                    ],
                    'in_transit_list' => [
                        'title' => '4 - List all In transit',
                        'route_name' => 'in-transit',
                        'permission' => 'delivery.create',
                    ],
                    'shipment' => [
                        'title' => '5 - Shipment',
                        'route_name' => 'shipment',
                        'permission' => 'delivery.create',
                    ],
                ],

            ],
        ];
    }

    public static function delivery()
    {
        return [
            'title' => 'Manage Deliveries',
            'items' => [
                [

                    'create_delivery_group' => [
                        'title' => '1 - Add a new delivery',
                        'route_name' => 'data-inquiry',
                        'permission' => 'delivery.create',
                    ],
                    'list_all_delivery' => [
                        'title' => '2 - List all deliveries',
                        'route_name' => 'delivery',
                        'permission' => 'delivery.view',
                    ],
                    'assign_delivery' => [
                        'title' => '3 - Assign drivers',
                        'route_name' => 'assign-driver',
                        'permission' => 'delivery.assign',
                    ],
                    'transfer_delivery' => [
                        'title' => '4 - Transfer deliveries',
                        'route_name' => 'change-driver',
                        'permission' => 'delivery.transfer',
                    ],
                    'remove_delivery' => [
                        'title' => '5 - Remove deliveries',
                        'route_name' => 'remove-delivery',
                        'permission' => 'delivery.remove',
                    ],

                ],

            ],
        ];
    }

    public static function driverPayment()
    {
        return [
            'title' => 'Driver Payment',
            'items' => [
                [
                    'collect_payment_with_driver' => [
                        'title' => '1 - Collect driver payment',
                        'route_name' => 'driver-collect-payment',
                        'permission' => 'driver-payment.view',
                    ],
                    'summary_driver_payment' => [
                        'title' => '2 - Driver payment summary',
                        'route_name' => 'driver-payment',
                        'permission' => 'driver-payment.view',
                    ],
                ],

            ],
        ];
    }

    public static function customerPayment()
    {
        return [
            'title' => 'Customer Payments',
            'items' => [
                [
                    'all_shop' => [
                        'title' => '1 - All shops',
                        'route_name' => 'all-shop-collect-payment',
                        'permission' => 'customer-payment.view',
                    ],
                    'collect_payment_with_shop' => [
                        'title' => '2 - Collect payment',
                        'route_name' => 'shop-collect-payment',
                        'permission' => 'customer-payment.view',
                    ],
                    'summary_shop_payment' => [
                        'title' => '3 - Payment summary',
                        'route_name' => 'shop-summary-payment',
                        'permission' => 'customer-payment.view',
                    ],
                    'income_from_delivery' => [
                        'title' => '4 - EOD summary',
                        'route_name' => 'summaryIncomeFromDelivery',
                        'permission' => 'customer-payment.view',
                    ],

                ],

            ],
        ];
    }

    public static function reports()
    {
        return [
            'title' => 'Reports',
            'items' => [
                [
                    'list_all_report' => [
                        'title' => '1.List all reports',
                        'route_name' => 'reports',
                        'permission' => 'reports.view',
                    ],
                    'driver_earning' => [
                        'title' => '2.Driver Earning From Delivery',
                        'route_name' => 'driverEarning',
                        'permission' => 'reports.view',
                    ],
                    'driver_pickup_commission' => [
                        'title' => '3.Driver PickUp Commission',
                        'route_name' => 'pickUpCommission',
                        'permission' => 'reports.view',
                    ],
                    'income_from_shop' => [
                        'title' => '4.Income From Customers',
                        'route_name' => 'incomeShop',
                        'permission' => 'reports.view',
                    ],

                ],

            ],
        ];
    }

    public static function configuration()
    {
        return [
            'title' => 'Configurations',
            'items' => [
                [
                    'branch' => [
                        'title' => '1 - Branches',
                        'route_name' => 'branch',
                        'permission' => 'branch.view',
                    ],
                    'warehouse' => [
                        'title' => '2 - Warehouse',
                        'route_name' => 'warehouse',
                        'permission' => 'branch.view',
                    ],
                    'roles_permission' => [
                        'title' => '3 - Roles & Permissions',
                        'route_name' => 'roles',
                        'permission' => 'roles.view',
                    ],
                    'users' => [
                        'title' => '4 - Users',
                        'route_name' => 'users',
                        'permission' => 'users.view',
                    ],
                    'cancel' => [
                        'title' => '5 - Cancel Reasons',
                        'route_name' => 'cancel-reason',
                        'permission' => 'cancel-reason.view',
                    ],
                    'zone_type' => [
                        'title' => '6 - Zone Types',
                        'route_name' => 'zone-types',
                        'permission' => 'zone-types.view',
                    ],
                    'zone' => [
                        'title' => '7 - Zones & Pricing',
                        'route_name' => 'zone-price',
                        'permission' => 'zone-price.view',
                    ],
                    'assign_zone' => [
                        'title' => '8 - Assign & Zone',
                        'route_name' => 'assign-zones',
                        'permission' => 'assign-zones.view',
                    ],
                    'global_exchange_rate' => [
                        'title' => '9 - Global Exchange rate',
                        'route_name' => 'global-exchange-rate',
                        'permission' => 'global-exchange-rate.view',
                    ],
                ],
            ],
        ];
    }

    public static function setting()
    {
        return [
            'title' => 'Manage Settings',
            'items' => [
                [
                    'setting' => [
                        'title' => 'Setting',
                        'route_name' => 'setting',
                        'permission' => 'setting.view',
                    ],
                ],
            ],
        ];
    }

    public static function all()
    {
        return [self::dashboards(), self::booking(),  self::delivery(), self::customer(), self::driverPayment(),
            self::customerPayment(), self::reports(), self::setting(), self::configuration()];
    }
}
