<?php

namespace App\Http\Requests\ZoneType;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'zone_type' => 'required|string|max:255|unique:zone_type,zone_type,'.$this->route('zone_type')->id,
            'status' => 'required|in:active,inactive',
            'express' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
        ];
    }
}
