<?php

namespace App\Http\Requests\ZonePrice;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'zone_type' => 'required|numeric',
            'zone_name' => 'required',
            'status' => 'required|in:active,inactive',
            'price' => 'required|numeric|min:0',
        ];
    }
}
