<?php

namespace App\Http\Requests\Users;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true; // Adjust this based on your authorization logic
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'display_name' => 'required|string|max:255',
            'name' => 'required|max:255|unique:users,name',
            'email' => 'nullable|email|unique:users,email',
            'phone' => 'required|max:20|unique:users,phone',
            'gender' => 'required|in:male,female',
            'status' => 'required|in:active,inactive',
            'role' => 'required|exists:roles,name',
            'branches' => 'required|array',
            'branches.*' => 'exists:branches,id',
            'password' => 'required|string|min:8|confirmed',
        ];
    }
}
