<?php

namespace App\Http\Requests\Delivery;

use Illuminate\Foundation\Http\FormRequest;

class PaymentProcessRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'delivery_id' => 'required|exists:delivery,id',
            'payments' => 'required|array|min:1',
            'payments.*.payment_to' => 'required|in:shop,driver,company',
            'payments.*.amount' => 'required|numeric|min:0',
            'payments.*.currency' => 'required|in:usd,khr',
            'payments.*.payment_method' => 'required|in:cash,transfer,aba,wing',
            'payments.*.note' => 'nullable|string|max:255',
        ];
    }

    public function messages(): array
    {
        return [
            'payments.*.payment_to.required' => 'Payment to is required for each payment.',
            'payments.*.amount.required' => 'Amount is required for each payment.',
            'payments.*.amount.numeric' => 'Amount must be a valid number for each payment.',
            'payments.*.amount.min' => 'Amount must be greater than zero for each payment.',
            'payments.*.currency.required' => 'Currency is required for each payment.',
            'payments.*.currency.in' => 'Currency must be either USD or KHR for each payment.',
            'payments.*.payment_method.required' => 'Payment method is required for each payment.',
            'payments.*.payment_method.in' => 'Payment method must be either cash, transfer, ABA, or Wing for each payment.',
            'payments.*.note.string' => 'Note must be a string for each payment.',
            'payments.*.note.max' => 'Note may not be greater than 255 characters for each payment.',
            'delivery_id.required' => 'Delivery ID is required.',
            'delivery_id.exists' => 'The selected delivery does not exist.',
            'payments.required' => 'At least one payment is required.',
            'payments.array' => 'Payments must be an array.',
            'payments.min' => 'At least one payment must be provided.',
            'payments.*.payment_to.in' => 'Payment to must be either shop, driver, or company.',
        ];
    }
}
