<?php

namespace App\Http\Requests\DataInquiry;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'customer_id' => 'required|exists:customers,id',
            'pickup_by' => 'required|exists:users,id',
            'delivery_by' => 'nullable|exists:users,id',
            'items' => 'required|array|min:1',

            'items.*.receiver_address' => 'required|string',
            'items.*.delivery_price' => 'required|numeric|min:0',

            'items.*.receiver_phone' => [
                'required',
                'regex:/^((0(10|11|12|13|14|15|16|17|18|70|71|76|77|78|79|81|85|86|87|88|89|90|92|93|95|96|97|98|99)[0-9]{6})|(\+855(10|11|12|13|14|15|16|17|18|70|71|76|77|78|79|81|85|86|87|88|89|90|92|93|95|96|97|98|99)[0-9]{6}))$/',
            ],

            'items.*.amount_usd' => [
                'nullable',
                'numeric',
                'min:0',
                'regex:/^\d{1,9}(\.\d{1,2})?$/',
            ],

            'items.*.amount_khr' => [
                'nullable',
                'numeric',
                'min:0',
                'regex:/^\d{1,10}$/',
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'items.*.receiver_phone.regex' => 'Please enter a valid Cambodian phone number (e.g., 010123456 or +85510123456).',
        ];
    }
}
