<?php

namespace App\Http\Requests\BookingOrder;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'customer_id' => 'required|exists:customers,id',
            'from_warehouse' => 'required',
            'to_warehouse' => 'nullable',

            // item fields
            'items.*.tracking_number' => 'required|string|max:191',
            'items.*.shipping_method' => 'required|string|in:land,air,sea',

            'items.*.pcs' => 'required|numeric|min:0',
            'items.*.kg' => 'required|numeric|min:0',
            'items.*.cbm' => 'required|numeric|min:0',

            'items.*.amount_usd' => [
                'nullable',
                'numeric',
                'min:0',
                'regex:/^\d{1,9}(\.\d{1,2})?$/',
            ],

            'items.*.photo' => [
                'nullable',
                'image',
                'mimes:jpg,jpeg,png,webp',
                'max:2048', // 2MB
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'items.*.photo.image' => 'Uploaded file must be an image.',
            'items.*.photo.mimes' => 'Image must be JPG, PNG, or WEBP.',
            'items.*.photo.max' => 'Image size must not exceed 2MB.',
        ];
    }
}
