<?php

namespace App\Http\Requests\Api\Delivery;

use App\Enums\DeliveryStatus;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Enum;

class DeliveryByDriverRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            /**
             * driver id.
             */
            'driver_id' => 'required|integer',
            'customer_id' => 'nullable|integer',
            'status' => ['nullable', new Enum(DeliveryStatus::class)],
        ];
    }
}
