<?php

namespace App\Http\Middleware;

use App\Models\Branch;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;
use Symfony\Component\HttpFoundation\Response;

class LoadCurrentBranch
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $branch = null;

        if (Session::has('current_branch_id')) {
            $branch = Branch::find(Session::get('current_branch_id'));
        } elseif (Auth::check() && Auth::user()->default_branch_id) {
            $branch = Branch::find(Auth::user()->default_branch_id);
        }

        View::share('currentBranch', $branch);

        return $next($request);
    }
}
