<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Activitylog\Models\Activity;
use Yajra\DataTables\DataTables;

class ActivityLogController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = Activity::with('causer')->latest();

            return DataTables::of($data)
                ->addColumn('user', function ($row) {
                    return optional($row->causer)->name ?? 'System';
                })
                ->editColumn('created_at', function ($row) {
                    return $row->created_at ? $row->created_at->format('d-M-Y H:i') : 'N/A';
                })
                ->addColumn('changes', function ($row) {
                    $properties = $row->properties;

                    if (isset($properties['attributes']) && isset($properties['old']) && is_array($properties['attributes'])) {
                        $html = '';
                        foreach ($properties['attributes'] as $key => $value) {
                            $old = $properties['old'][$key] ?? '-';
                            $html .= "<div><strong>{$key}</strong>: <span class='text-red-600'>{$old}</span> ➔ <span class='text-green-600'>{$value}</span></div>";
                        }

                        return $html;
                    }

                    return 'N/A';
                })

                ->rawColumns(['changes'])
                ->make(true);
        }
    }
}
