<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Validation\ValidationException;
use Throwable;

class Handler extends ExceptionHandler
{
    public function render($request, Throwable $exception)
    {
        if ($exception instanceof ValidationException && $request->is('api/*')) {
            return $this->invalidJson($request, $exception);
        }

        return parent::render($request, $exception);
    }

    public function invalidJson($request, ValidationException $exception)
    {
        return response()->json([
            'success' => false,
            'message' => 'Validation errors',
            'errors' => $exception->errors(),
        ], $exception->status);
    }
}
