<?php

namespace App\Enums;

enum PaymentTo: string
{
    case DRIVER = 'driver';
    case SHOP = 'shop';
    case COMPANY = 'company';

    public function label(): string
    {
        return match ($this) {
            self::DRIVER => 'Driver',
            self::SHOP => 'Shop',
            self::COMPANY => 'Company',
        };
    }
}
