<?php

namespace Database\Seeders;

use App\Models\Warehouse;
use App\Models\WarehouseAddress;
use Illuminate\Database\Seeder;

class WarehouseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create a warehouse
        Warehouse::create([
            'branch_id' => 1,
            'name' => 'China Warehouse',
        ]);

        // Land import address
        WarehouseAddress::create([
            'warehouse_id' => 1,
            'import_type' => 'land',
            'phone' => '18666103173',
            'address' => '广东省佛山市南海区里水镇甘河路29号 承運供应链',
        ]);

        // Sea import address
        WarehouseAddress::create([
            'warehouse_id' => 1,
            'import_type' => 'sea',
            'phone' => '18666103173',
            'address' => '广东省佛山市南海区里水镇甘河路29号',
        ]);
        // air import address
        WarehouseAddress::create([
            'warehouse_id' => 1,
            'import_type' => 'air',
            'phone' => '18666103173',
            'address' => '广东省佛山市南海区里水镇甘河路29号',
        ]);
        // Create a warehouse
        Warehouse::create([
            'branch_id' => 1,
            'name' => 'Phnom Penh Warehouse',
        ]);

    }
}
