<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('in_transit', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\InTransitSummary::class, 'in_transit_summary_id')
                ->constrained('in_transit_summary')
                ->onDelete('cascade');
            $table->unsignedBigInteger('delivery_id');
            $table->timestamp('date')->nullable();
            $table->foreign('delivery_id')->references('id')->on('delivery')->onDelete('cascade');
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('in_transit');
    }
};
