<?php

use App\Models\Customer;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('summary_shop_payment', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number')->nullable();
            $table->float('exchange_rate', 10, 2)->default(1.0);
            $table->decimal('total_amount_usd', 10, 2)->default(0.00);
            $table->decimal('total_amount_khr', 10, 2)->default(0.00);
            $table->decimal('service_fee', 10, 2)->default(0.00);
            $table->date('payment_date')->nullable();
            $table->foreignIdFor(Customer::class, 'customer_id')->constrained()->onDelete('cascade');
            $table->string('status')->default('pending'); // pending, paid, cancelled
            $table->text('note')->nullable();
            $table->bigInteger('total_new_package')->default(0);
            $table->bigInteger('total_old_package')->default(0);
            $table->bigInteger('completed')->default(0);
            $table->bigInteger('assigned')->default(0);
            $table->bigInteger('canceled')->default(0);
            $table->bigInteger('return')->default(0);
            $table->bigInteger('in_stock')->default(0);

            $table->foreignIdFor(\App\Models\User::class, 'created_by')->constrained('users')->onDelete('cascade');
            $table->foreignIdFor(\App\Models\User::class, 'updated_by')->nullable()->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('summary_shop_payment');
    }
};
